% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-mail.R
\name{keywords}
\alias{keywords}
\title{Add or query keywords of message.}
\usage{
keywords(msg, ..., append = FALSE)
}
\arguments{
\item{msg}{A message object.}

\item{...}{Keywords.}

\item{append}{Whether to append or replace keywords.}
}
\value{
A message object or the comments of the message object (if \code{comments} is \code{NULL}).
}
\description{
Add or query keywords of message.
}
\examples{
# Create a message and set the keywords.
envelope() \%>\% keywords("newsletter, marketing")
envelope() \%>\% keywords("newsletter", "marketing")
envelope() \%>\% keywords(c("newsletter", "marketing"))

# Retrieve the keywords for a message.
msg <- envelope() \%>\% keywords("newsletter, marketing")
keywords(msg)
}
\seealso{
\code{\link{to}}, \code{\link{from}}, \code{\link{cc}}, \code{\link{bcc}} and \code{\link{reply}}
}
