% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_facet.r
\name{tag_facet_outside}
\alias{tag_facet_outside}
\title{tag_facet_outside}
\usage{
tag_facet_outside(p, open = c("(", ""), close = c(")", "."),
  tag_fun_top = function(i) letters[i],
  tag_fun_right = utils::as.roman, x = c(0, 0), y = c(0.5, 1),
  hjust = c(0, 0), vjust = c(0.5, 1), fontface = c(2, 2),
  family = "", draw = TRUE, ...)
}
\arguments{
\item{p}{ggplot}

\item{open}{opening character, default: (}

\item{close}{closing character, default: )}

\item{tag_fun_top}{labelling function}

\item{tag_fun_right}{labelling function}

\item{x}{x position within cell}

\item{y}{y position within cell}

\item{hjust}{hjust}

\item{vjust}{vjust}

\item{fontface}{fontface}

\item{family}{font family}

\item{draw}{logical: draw the resulting gtable}

\item{...}{further arguments passed to geom_text layer}
}
\value{
plot with facet strips removed and replaced by in-panel tags
}
\description{
Adds a dummy text layer to a ggplot to label facets and sets facet strips to blank. 
This is the typical formatting for some journals that consider facets as subfigures 
and want to minimise margins around figures.
}
\examples{
library(ggplot2)
d = data.frame(
  x = 1:90,
  y = rnorm(90),
  red = rep(letters[1:3], 30),
  blue = c(rep(1, 30), rep(2, 30), rep(3, 30)))

p <- ggplot(d) +
  geom_point(aes(x = x, y = y)) +
  facet_grid(red ~ blue)
  
tag_facet_outside(p)

}
