% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_util_dummy_mutualeclusive}
\alias{ec_util_dummy_mutualeclusive}
\title{Find mutually exclusive columns}
\usage{
ec_util_dummy_mutualeclusive(data_in, filtered = TRUE)
}
\arguments{
\item{data_in}{A data frame containing the data.}

\item{filtered}{A logical value indicating whether to return only the mutually exclusive pairs (TRUE) or all pairs (FALSE). Default is TRUE.}
}
\value{
A tibble containing all pairs of mutually exclusive columns in the data frame.
}
\description{
This function finds pairs of columns in a data frame that are mutually exclusive, i.e., that never have positive values at the same time.
}
\examples{
minidata=structure(list(id = c("1", "1", "1", "1", "2", "2", "2", "2"), 
task = c(1L, 1L, 2L, 2L, 3L, 3L, 4L, 4L), 
alt = c(1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L), 
brand1 = c(1, 0, 1, 0, 1, 0, 1, 0), 
brand2 = c(0, 1, 0, 1, 0, 1, 0, 1), 
price = c(1, 2, 1, 2, 1, 2, 1, 2), 
x = c(1, 0, 0, 1, 1, 0, 1, 0)), 
class = c("tbl_df", "tbl", "data.frame"), row.names = c(NA, -8L))
ec_util_dummy_mutualeclusive(minidata)


}
