% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fred_category.R
\name{fred_category}
\alias{fred_category}
\alias{fred_category_children}
\alias{fred_category_related}
\alias{fred_category_series}
\alias{fred_category_tags}
\alias{fred_category_related_tags}
\title{Fetch Information on a Category in FRED}
\usage{
fred_category(..., key = NULL)

fred_category_children(
  ...,
  key = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)

fred_category_related(
  ...,
  key = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)

fred_category_series(..., key = NULL, args = list())

fred_category_tags(..., key = NULL, args = list())

fred_category_related_tags(..., key = NULL, args = list())
}
\arguments{
\item{...}{character or numeric vectors of a category ID to fetch. Names are ignored.}

\item{key}{32 character lower-cased alpha-numeric character string}

\item{realtime_start, realtime_end}{character date strings of format "YYY-MM-DD" used obtain information that was known during the specified time period. If empty, the latest update of the information is used.}

\item{args}{named list of other arguments passed to the API, including "limit", "offset", "sort_order", etc. See \code{\link{fred_search}} for more details on accepted parameters.}
}
\value{
data.frame with entries described in details
}
\description{
Each of the functions accept a category ID and return the requested information in a data.frame.
}
\details{
Each function returns the following information in a data.frame.

\describe{
 \item{\code{fred_category}}{Category id, its name, and the id of its parent}
 \item{\code{fred_category_children}}{Same as \code{fred_category}}
 \item{\code{fred_category_related}}{Same as \code{fred_category}}
 \item{\code{fred_category_series}}{Series id, its title, observations start and end, frequency, units, seasonal adjustment type, popularity, realtime start and end, and when it was last updated}
 \item{\code{fred_category_tags}}{Tag name and its group id, popularity of tag, number of series in each tag, when it was created, and other notes}
 \item{\code{fred_category_related_tags}}{Same as \code{fred_category_tags}}
}
}
\section{Functions}{
\itemize{
\item \code{fred_category}: get the name and parent_id for a FRED category

\item \code{fred_category_children}: get the category children ids of a given parent_id

\item \code{fred_category_related}: get the categories that are related to a category id

\item \code{fred_category_series}: get all series within a particular category

\item \code{fred_category_tags}: get all tags associated with a particular category

\item \code{fred_category_related_tags}: get all tags related to tags within a particular category
}}

\examples{
\dontrun{
api_key <- "abcdefghijklmnopqrstuvwxyz123456"

# What category is the unemployment rate in?
un_cat <- fred_category("UNRATE", key=api_key)

# What other series are in the same category?
other_in_cat <- fred_category_series(un_cat$id, key=api_key)
head(other_in_cat)
}

}
