% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-from-ints.R
\name{dtt_date_from_ints}
\alias{dtt_date_from_ints}
\title{Create Dates from Integers}
\usage{
dtt_date_from_ints(year = 1972L, month = 1L, day = 1L)
}
\arguments{
\item{year}{An integer of the year. The default value is 1972.}

\item{month}{An integer of the month between 1 and 12. The default value is
the 1st month.}

\item{day}{An integer of the day between 1 and 31. The default value is the
1st day.}
}
\value{
A floored Date vector.
}
\description{
Create date object from vectors of year, month and day values.
}
\details{
This can be very helpful when needing to create a date column in a
data frame from year, month and days columns. Vectors must all be the same
length or be of length one.
}
\examples{
dtt_date_from_ints(
  year = 1991,
  month = 07,
  day = 23
)

dtt_date_from_ints(
  year = c(1991, 1992, 1993),
  month = c(07, 07, 07),
  day = c(23, 24, 21)
)

year_vals <- c(1991, 1992, 1993)
month_vals <- c(07, 07, 07)
day_vals <- c(23, 24, 21)
dtt_date_from_ints(year_vals, month_vals, day_vals)

year_vals <- 2022
month_vals <- 1:12
day_vals <- 15
dtt_date_from_ints(year_vals, month_vals, day_vals)

dtt_date_from_ints(year_vals, month_vals)
}
\seealso{
Other creates: 
\code{\link{dtt_date_time_from_ints}()},
\code{\link{dtt_time_from_ints}()}
}
\concept{creates}
