% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsem.R
\name{predict.dsem}
\alias{predict.dsem}
\title{predictions using dsem}
\usage{
\method{predict}{dsem}(object, newdata = NULL, type = c("link", "response"), ...)
}
\arguments{
\item{object}{Output from \code{\link{dsem}}}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict.
If omitted, the fitted data are used to create predictions. If desiring predictions after the fitted data,
the user must append rows with NAs for those future times.  Similarly, if desiring predictions given counterfactual
values for time-series data, then those individual observations can be edited while keeping other observations at their
original fitted values.}

\item{type}{the type of prediction required. The default is on the scale of the linear predictors;
the alternative "response" is on the scale of the response variable.
Thus for a Poisson-distributed variable the default predictions are of log-intensity and type = "response" gives the predicted intensity.}

\item{...}{Not used}
}
\value{
A matrix of predicted values with dimensions and order corresponding to
argument \code{newdata} is provided, or \code{tsdata} if not.
Predictions are provided on either link or response scale, and
are generated by re-optimizing random effects condition on MLE
for fixed effects, given those new data.
}
\description{
Predict variables given new (counterfactual) values of data, or for future or past times
}
