% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{splitn}
\alias{splitn}
\alias{dsplitn}
\alias{psplitn}
\alias{qsplitn}
\alias{rsplitn}
\title{Split-normal distribution}
\usage{
dsplitn(x, mu, sigma, lmd, logarithm)

psplitn(q, mu, sigma, lmd)

qsplitn(p, mu, sigma, lmd)

rsplitn(n, mu, sigma, lmd)
}
\arguments{
\item{x}{vector of quantiles.}

\item{mu}{vector of location parameter. (The mode of the density)}

\item{sigma}{vector of standard deviations.}

\item{lmd}{vector of skewness parameters (>0). If is 1, reduced to
symmetric normal distribution.}

\item{logarithm}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{p}{vector of probability.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
\code{dsplitn} gives the density; \code{psplitn} gives the percentile;
\code{qsplitn} gives the quantile; and \code{rsplitn} gives the random
variables. Invalid arguments will result in return value NaN, with a warning.

The numerical arguments other than n are recycled to the length of the
result. Only the first elements of the logical arguments are used.
}
\description{
Density distribution function, quantile function and random generation function for
the split normal distribution.
}
\details{
The random ' variable y follows a split-normal distribution, y~N(\eqn{\mu}, '
\eqn{\sigma}, \eqn{\lambda}), which has density: \deqn{1/(1+\lambda)\sigma ' \sqrt(2/\pi)
exp{-(y-\mu)*2/2\sigma^2}, if y<=\mu} ' \deqn{1/(1+\lambda)\sigma \sqrt(2/\pi)
exp{-(y-\mu)*2/2\sigma^2 \lambda^2}, ' if y>\mu} where \eqn{\sigma>0} and
\eqn{\lambda>0}. The Split-normal ' distribution reduce to normal distribution when
\eqn{\lambda=1}.
}
\section{Functions}{
\itemize{
\item \code{psplitn}: Percentile for the split-normal distribution.

\item \code{qsplitn}: Quantile for the split-normal distribution.

\item \code{rsplitn}: Randon variables from the split-normal distribution.
}}

\examples{

n <- 3
mu <- c(0,1,2)
sigma <- c(1,2,3)
lmd <- c(1,2,3)

q0 <- rsplitn(n, mu, sigma, lmd)
d0 <- dsplitn(q0, mu, sigma, lmd, logarithm = FALSE)
p0 <- psplitn(q0, mu, sigma, lmd)
q1 <- qsplitn(p0,mu, sigma, lmd)
all.equal(q0, q1)
}
\references{
Villani, M., & Larsson, R. (2006) The Multivariate Split Normal
Distribution and Asymmetric Principal Components Analysis. Sveriges
Riksbank Working Paper Series, No. 175.
}
\seealso{
\code{\link{splitn_mean}()},
\code{\link{splitn_var}()},\code{\link{splitn_skewness}()} and
\code{\link{splitn_kurtosis}()} for numerical characteristics of the
split-normal distribution.
}
\author{
Feng Li, Jiayue Zeng
}
\keyword{asymmetric}
\keyword{distribution}
\keyword{normal}
