% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disambiguate.R
\name{dm_disambiguate_cols}
\alias{dm_disambiguate_cols}
\title{Resolve column name ambiguities}
\usage{
dm_disambiguate_cols(
  dm,
  .sep = ".",
  ...,
  .quiet = FALSE,
  .position = c("suffix", "prefix")
)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{.sep}{The character variable that separates the names of the table and the names of the ambiguous columns.}

\item{...}{These dots are for future extensions and must be empty.}

\item{.quiet}{Boolean.
By default, this function lists the renamed columns in a message, pass \code{TRUE} to suppress this message.}

\item{.position}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
By default, table names are appended to the column names to resolve conflicts.
Prepending table names was the default for versions before 1.0.0,
use \code{"prefix"} to achieve this behavior.}
}
\value{
A \code{dm} whose column names are unambiguous.
}
\description{
This function ensures that all columns in a \code{dm} have unique names.
}
\details{
The function first checks if there are any column names that are not unique.
If there are, those columns will be assigned new, unique, names by prefixing their existing name
with the name of their table and a separator.
Columns that act as primary or foreign keys will not be renamed
because only the foreign key column will remain when two tables are joined,
making that column name "unique" as well.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_disambiguate_cols()
\dontshow{\}) # examplesIf}
}
