% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_dm_to.R
\name{dm_sql}
\alias{dm_sql}
\alias{dm_ddl_pre}
\alias{dm_dml_load}
\alias{dm_ddl_post}
\title{Create \emph{DDL} and \emph{DML} scripts for \code{dm} and database connection}
\usage{
dm_sql(dm, dest, temporary = TRUE, schema = NULL)

dm_ddl_pre(
  dm,
  dest,
  temporary = TRUE,
  table_names = set_names(names(dm)),
  set_key_constraints = TRUE,
  schema = NULL
)

dm_dml_load(dm, dest, table_names = set_names(names(dm)))

dm_ddl_post(dm, dest, table_names = set_names(names(dm)), schema = NULL)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{dest}{Connection to database.}

\item{temporary}{Should the tables be marked as \emph{temporary}? Defaults to \code{TRUE}.}

\item{schema}{Name of schema to copy the \code{dm} to.}

\item{table_names}{See argument description in \link{copy_dm_to}. Default to names of \code{dm}.}

\item{set_key_constraints}{If \code{TRUE} (default) will mirror \code{dm} primary and foreign key constraints on a database
and create unique indexes.}
}
\value{
character vector of SQL statements.
}
\description{
Generate SQL scripts to create tables, load data and set constraints, keys and indices.
}
\details{
\itemize{
\item{ \code{dm_ddl_pre} generates \verb{CREATE TABLE} statements (including \verb{PRIMARY KEY} definition). }
\item{ \code{dm_dml_load} generates \verb{INSERT INTO} statements. }
\item{ \code{dm_ddl_post} generates scripts for \verb{FOREIGN KEYS}, \verb{UNIQUE KEYS} and \code{INDEXES}. }
\item{ \code{dm_sql} calls all three above and returns complete set of scripts. }
}
}
\examples{
\dontshow{if (rlang::is_installed("RSQLite") && rlang::is_installed("dbplyr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- DBI::dbConnect(RSQLite::SQLite())
dm <- dm_nycflights13()
s <- dm_sql(dm, con)
s
DBI::dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
