% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{unique_tol}
\alias{unique_tol}
\title{Get unique values in a sorted numeric vector, where comparison is up to a
specified numeric tolerance. If there is a run of values where each
consecutive pair is closer together than the tolerance, all are labeled as
corresponding to a single unique value even if not all values in the run are
within the tolerance.}
\usage{
unique_tol(x, tol = 1e-06, ties = mean)
}
\arguments{
\item{x}{a numeric vector in which to identify duplicates}

\item{tol}{numeric tolerance for identifying duplicates}

\item{ties}{a function that is used to summarize groups of values that fall
within the tolerance}
}
\value{
a numeric vector of the unique values in \code{x}
}
\description{
Get unique values in a sorted numeric vector, where comparison is up to a
specified numeric tolerance. If there is a run of values where each
consecutive pair is closer together than the tolerance, all are labeled as
corresponding to a single unique value even if not all values in the run are
within the tolerance.
}
