% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{mono_Hermite_spline}
\alias{mono_Hermite_spline}
\title{Create a polySpline object representing a monotonic Hermite spline
interpolating a given set of points.}
\usage{
mono_Hermite_spline(x, y, m)
}
\arguments{
\item{x}{vector giving the x coordinates of the points to be interpolated.}

\item{y}{vector giving the y coordinates of the points to be interpolated.
Must be increasing or decreasing for 'method = "hyman"'.}

\item{m}{(for 'splinefunH()') vector of \emph{slopes} \eqn{m_i}{m[i]} at the
points \eqn{(x_i,y_i)}{(x[i],y[i])}; these together determine the
\emph{H}ermite “spline” which is piecewise cubic, (only) \emph{once} differentiable
continuously.}
}
\value{
An object of class \code{polySpline} with the spline object, suitable for
use with other functionality from the \code{splines} package.
}
\description{
Create a polySpline object representing a monotonic Hermite spline
interpolating a given set of points.
}
\details{
This function essentially reproduces \code{stats::splinefunH}, but it
returns a polynomial spline object as used in the \code{splines} package rather
than a function that evaluates the spline, and potentially makes
adjustments to the input slopes \code{m} to enforce monotonicity.
}
