% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-describe.R
\name{ds_tailobs}
\alias{ds_tailobs}
\title{Tail Observations}
\usage{
ds_tailobs(data, n, type = c("low", "high"))
}
\arguments{
\item{data}{a numeric vector}

\item{n}{number of observations to be returned}

\item{type}{if \code{low}, the \code{n} lowest observations are returned, else the
highest \code{n} obervations are returned}
}
\value{
\code{n} highest/lowest observations from \code{data}
}
\description{
Returns the n highest/lowest observations from a numeric vector.
}
\details{
Any NA values are stripped from \code{data} before computation
takes place.
}
\examples{
ds_tailobs(mtcarz$mpg, 5)
ds_tailobs(mtcarz$mpg, 5, type = "high")
}
\seealso{
\code{\link[dplyr]{top_n}}
}
