% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_accessors.R
\name{getSimData}
\alias{getSimData}
\alias{getConditionNames}
\alias{getTrueNetwork}
\title{Get data and conditions from a given knock-down (KD)}
\usage{
getSimData(simulation, cond.name = NULL, full = FALSE)

getConditionNames(simulation)

getTrueNetwork(
  simulation,
  cond.name = NULL,
  truth.type = c("association", "influence", "direct"),
  full = FALSE
)
}
\arguments{
\item{simulation}{a list, storing data and results generated from simulations}

\item{cond.name}{a character, indicating the knock-down to use to derive
conditions. Multiple knock-downs (KDs) are performed per simulation. If
\code{NULL}, the first KD is chosen}

\item{full}{a logical, indicating whether genes associated with the condition
should be excluded. Defaults to \code{FALSE} and is recommended}

\item{truth.type}{a character, specifying which level of the true network to
retrieve: 'association' (default), 'influence' or 'direct'}
}
\value{
a list, containing \code{emat}, a matrix representing the expression
 data, \code{condition}, a numeric containing the classification of samples,
 and , \code{condition_c}, a numeric containing the expression levels of the
 KD gene (continuous condition) for \code{getSimData}; the names of all genes
 that are KD for \code{getConditionNames}; and an adjacency matrix for
 \code{getTrueNetwork}.
}
\description{
Retrieves the simulated expression matrix and sample
 classification for a specific knock-down experiment.
}
\details{
Genes discarded when \code{full} is \code{FALSE} are those that are
 solely dependent on the condition. These genes are discarded from the
 analysis to focus on those that are differentially co-expressed, not
 coordinately co-expressed.

 The names of all genes knocked-out can be retrieved using
 \code{getConditionNames}.

 The direct, influence and association networks represent different levels of
 true differential networks. The direct network contains differential
 regulatory interactions present in the original network. The influence
 network includes upstream interactions and the association network includes
 non-causative differential interactions.
}
\section{Functions}{
\itemize{
\item \code{getSimData}: get the expression matrix and sample classification

\item \code{getConditionNames}: get names of the conditions (KDs)

\item \code{getTrueNetwork}: get the true differential network
}}

\examples{
data(sim102)
KDs <- getConditionNames(sim102)

#get simulated data
simdata <- getSimData(sim102, KDs[2])
cond <- simdata$condition
emat <- simdata$emat
zscores <- dcScore(emat, cond)

#get the true network to evaluate against
truenet <- getTrueNetwork(sim102, KDs[2], truth.type = 'association')

}
\seealso{
\code{\link{dcScore}}
}
