% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbacf_AR1.R
\name{dbacf_AR1}
\alias{dbacf_AR1}
\title{Robust dbacf in change point regression with AR(1) errors}
\usage{
dbacf_AR1(data, type = c("covariance", "correlation"), lags)
}
\arguments{
\item{data}{numeric vector or a univariate object of class \code{\link[stats]{ts}}.}

\item{type}{character string specifying whether covariance (default) or correlation must be computed.}

\item{lags}{numeric giving the number of lags to compute.}
}
\value{
An object of class "dbacf" containing:
\itemize{
   \item \code{acf} numeric vector of length \code{lags + 1} giving estimated (auto)covariance/correlation function
   \item \code{rho} numeric, estimate of autoregressive coefficient
   \item \code{acfType} string indicating whether \code{covariance} or \code{correlation} has been computed
   \item \code{n} integer giving \code{length(data)}
}
}
\description{
In the context of change point regression with a stationary AR(1) error process, this function
estimates the autoregressive coefficient along with the autocovariance/correlation function
as a function of given lags.
}
\examples{
ar1 <- arima.sim(n = 50, model = list(ar = c(0.5), order = c(1, 0, 0)), 
                 sd = 0.25)
dbacf_AR1(ar1, type="correlation", lags=10)

}
\references{
Chakar, S. and Lebarbier, E. and Lévy-Leduc, C. and Robin, S. (2017). \emph{A robust
approach for estimating change-points in the mean of an AR(1) process}, Bernoulli, \bold{23(2)},
1408-1447
}
