% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometry.R
\name{trigonometry}
\alias{trigonometry}
\alias{cosDeg}
\alias{sinDeg}
\alias{cosRev}
\alias{sinRev}
\title{Cosine and sine of a rational number}
\usage{
cosDeg(theta)

sinDeg(theta)

cosRev(theta)

sinRev(theta)
}
\arguments{
\item{theta}{an integer number, a \strong{gmp} rational number, or a
fraction given as a character string (e.g. \code{"2/7"})}
}
\value{
A cyclotomic number.
}
\description{
Cosine and sine of a rational angle as a cyclotomic number.
}
\details{
The function \code{cosDeg}, resp. \code{sinDeg}, returns the cosine,
  resp. the sine, of its argument assumed to be given in degrees.
  The function \code{cosRev}, resp. \code{sinRev}, returns the cosine,
  resp. the sine, of its argument assumed to be given in revolutions.
}
\examples{
cosDeg(60)
cosDeg("2/3")^2 + sinDeg("2/3")^2 == 1
}
