% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trapeze.R
\name{trapeze}
\alias{trapeze}
\title{Trapeze integration from a vector of function values evaluated at quadrature points}
\usage{
trapeze(x, fx)
}
\arguments{
\item{x}{grid of values for the quadrature (vector).}

\item{fx}{values of the function on the grid (vector).}
}
\value{
vector with a numerical approximation of \eqn{\int_{min(x)}^{max(x)} f(t) dt} on the grid using the trapeze method.
}
\description{
Trapeze integration from a vector of function values evaluated at quadrature points
}
\examples{
x = seq(-4,2,length=100) ; fx = dnorm(x) ; res = trapeze(x,fx)
cbind(true=pnorm(x),trapeze=res)

}
