% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_throttle.R
\name{crew_throttle}
\alias{crew_throttle}
\title{Create a stateful throttling object.}
\usage{
crew_throttle(seconds_interval = 0.5)
}
\arguments{
\item{seconds_interval}{Positive numeric of length 1, throttling interval.
The \code{poll()} method returns \code{TRUE} if and only if it was not called
in the last \code{seconds_interval} seconds.}
}
\value{
An \code{R6} object with throttle configuration settings and methods.
}
\description{
Create an \code{R6} object for throttling.
}
\details{
Throttling is a technique that limits how often a function is
called in a given period of time. \code{\link[=crew_throttle]{crew_throttle()}} objects support
the \code{throttle} argument of controller methods, which ensures auto-scaling
only happen every \code{seconds_interval} seconds. This helps avoid
overburdening the \code{mirai} dispatcher and other resources.
}
\examples{
throttle <- crew_throttle(seconds_interval = 0.5)
throttle$poll()
throttle$poll()
}
\seealso{
Other throttle: 
\code{\link{crew_class_throttle}}
}
\concept{throttle}
