% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/push.R
\name{push}
\alias{push}
\alias{push,CppStack-method}
\alias{push,CppQueue-method}
\alias{push,CppPriorityQueue-method}
\title{Add elements}
\usage{
push(x, values)
}
\arguments{
\item{x}{A CppStack, CppQueue, or CppPriorityQueue object.}

\item{values}{Values to add to \code{x}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Add elements to the top of a stack, to the back of a queue, or to a priority queue by reference.
}
\details{
The method iterates through \code{values} starting at the front of the vector. I.e., the last element of \code{values} is added last.
}
\examples{
s <- cpp_stack(1:4)
s
# Top element: 4

push(s, 8:9)
s
# Top element: 9

}
\seealso{
\link{back}, \link{emplace}, \link{front}, \link{pop}, \link{push}, \link{top}.
}
