% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{splineBasis}
\alias{splineBasis}
\title{Initialize and reparametrize a spline basis matrix}
\usage{
splineBasis(tau, sumToZero = TRUE, rescale01 = TRUE)
}
\arguments{
\item{tau}{\code{m x 1} vector of observed points}

\item{sumToZero}{logical; if TRUE, enforce a sum-to-zero constraint (useful for additive models)}

\item{rescale01}{logical; if TRUE, rescale \code{tau} to the interval [0,1] prior to computing
basis and penalty matrices}
}
\value{
\code{B_nl}: the nonlinear component of the spline basis matrix
}
\description{
Following Wand and Ormerod (2008), compute a low-rank thin plate spline
basis which is diagonalized such that the prior variance for the nonlinear component
is a scalar times a diagonal matrix. Knot locations are determined by quantiles
and the penalty is the integrated squared second derivative.
}
\note{
To form the full spline basis matrix, compute \code{cbind(1, tau, B_nl)}.
The sum-to-zero constraint implicitly assumes that the linear term is
centered and scaled, i.e., \code{scale(tau)}.
}
\keyword{internal}
