% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-ordered.R
\name{opts_ordered}
\alias{opts_ordered}
\title{Constructive options for class 'ordered'}
\usage{
opts_ordered(
  constructor = c("ordered", "factor", "new_ordered", "next", "atomic"),
  ...
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the environment, see Details section.}

\item{...}{Should not be used. Forces passing arguments by name.}
}
\value{
An object of class <constructive_options/constructive_options_factor>
}
\description{
These options will be used on objects of class 'ordered'.
}
\details{
Depending on \code{constructor}, we construct the environment as follows:
\itemize{
\item \code{"ordered"} (default): Build the object using a \code{ordered()} call, levels won't
be defined explicitly if they are in alphabetical order (locale dependent!)
\item \code{"factor"} : Same as above but build the object using a \code{factor()} call and \code{ordered = TRUE}.
\item \code{"new_ordered"} : Build the object using a \code{vctrs::new_ordered()}. Levels are
always defined explicitly.
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"atomic"} : We define as an atomic vector and repair attributes
}
}
