% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medians.R
\name{median}
\alias{median}
\title{Median, for Numeric or Complex}
\usage{
median(x, na.rm = FALSE, tol = 1e-07, maxiter = 200)
}
\arguments{
\item{x}{a numeric or complex vector, of which the median is to be calculated.}

\item{na.rm}{logical. Should NA values be removed before finding the median?}

\item{tol}{numeric. Relative tolerance to be passed to \link[pracma:geo_median]{pracma::geo_median}. Default is 1e-07.}

\item{maxiter}{maximum number of iterations for calculating geometric median. Not used if x is numeric.}
}
\value{
The median of x. If x is complex, the geometric median as calculated by Weiszfeld's algorithm.
}
\description{
Extends \link[stats:median]{stats::median} to understand complex variable input. If x is complex, the geometric median
is calculated by \link[pracma:geo_median]{pracma::geo_median}, and returned as a complex number. Otherwise, \link[stats:median]{stats::median} is called.
}
\examples{
set.seed(4242)
n <- 7
foo <- complex(real = rnorm(n), imaginary = rnorm(n))
median(foo)
}
\references{
See Wikipedia's entry on ``Geometric median''.
}
\seealso{
\link[stats:median]{stats::median} and \link[pracma:geo_median]{pracma::geo_median}
}
