% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCompVar.R
\name{makeCompVar}
\alias{makeCompVar}
\alias{makeCompVar.default}
\alias{makeCompVar.formula}
\title{Compute integrated means and covariances}
\usage{
makeCompVar(x, ...)

\method{makeCompVar}{default}(x, item.column, ...)

\method{makeCompVar}{formula}(x, data = NULL, ...)
}
\arguments{
\item{x}{a \code{matrix}, or \code{data.frame}, of observations, with cases in rows,
and properties as columns, or a \code{formula}.}

\item{\dots}{other arguments.}

\item{item.column}{an integer indicating which column gives the item.}

\item{data}{if \code{x} is a \code{formula}, then the user must supply a \code{data.frame}
containing the observations.}
}
\value{
an object of class \code{compvar}
}
\description{
Takes a large sample from the background population and calculates the within
and between covariance matrices, a vector of means, a vector of the counts of
replicates for each item from the sample, and other bits needed to make up a
\code{compcovar} object.
}
\details{
Uses ML estimation at the moment - this will almost certainly change in the future and
hopefully allow regularisation methods to get a more stable (and non-singular) estimate.
}
\section{Methods (by class)}{
\itemize{
\item \code{makeCompVar(default)}: Create a \code{compvar} object using a formula.

\item \code{makeCompVar(formula)}: Create a \code{compvar} object using a formula.

}}
\examples{
# load Greg Zadora's glass data
data(glass)

# calculate a compcovar object based upon glass
# using K, Ca and Fe - warning - could take time
# on slower machines
background = subset(glass, select = c(item, logKO, logCaO, logFeO))
Z1 = makeCompVar(background, 1)

# Use the formula interface
Z2 = makeCompVar(item ~ logKO + logCaO + logFeO, data = glass)
}
\author{
David Lucy and James Curran
}
