% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.R
\name{identify_predictors_numeric}
\alias{identify_predictors_numeric}
\title{Identify Valid Numeric Predictors}
\usage{
identify_predictors_numeric(df = NULL, predictors = NULL, decimals = 4)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{decimals}{(required, integer) Number of decimal places for the zero variance test. Smaller numbers will increase the number of variables detected as near-zero variance. Recommended values will depend on the range of the numeric variables in 'df'. Default: 4}
}
\value{
character vector: names of numeric predictors
}
\description{
Returns the names of valid numeric predictors. Ignores predictors with constant values or with near-zero variance.
}
\examples{
if (interactive()) {

data(
  vi,
  vi_predictors
)

numeric.predictors <- identify_predictors_numeric(
  df = vi,
  predictors = vi_predictors
)

numeric.predictors

}
}
\seealso{
Other data_types: 
\code{\link{identify_predictors}()},
\code{\link{identify_predictors_categorical}()},
\code{\link{identify_predictors_type}()},
\code{\link{identify_predictors_zero_variance}()},
\code{\link{identify_response_type}()}
}
\author{
Blas M. Benito, PhD
}
\concept{data_types}
