% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-unconstrain_draws}
\alias{fit-method-unconstrain_draws}
\alias{unconstrain_draws}
\title{Transform all parameter draws to the unconstrained scale}
\usage{
unconstrain_draws(files = NULL, draws = NULL)
}
\arguments{
\item{files}{(character vector) The paths to the CmdStan CSV files. These can
be files generated by running CmdStanR or running CmdStan directly.}

\item{draws}{A \verb{posterior::draws_*} object.}
}
\description{
The \verb{$unconstrain_draws()} method transforms all parameter draws
to the unconstrained scale. The method returns a list for each chain,
containing the parameter values from each iteration on the unconstrained
scale. If called with no arguments, then the draws within the fit object
are unconstrained. Alternatively, either an existing draws object or a
character vector of paths to CSV files can be passed.
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample", force_recompile = TRUE)
fit_mcmc$init_model_methods()

# Unconstrain all internal draws
unconstrained_internal_draws <- fit_mcmc$unconstrain_draws()

# Unconstrain external CmdStan CSV files
unconstrained_csv <- fit_mcmc$unconstrain_draws(files = fit_mcmc$output_files())

# Unconstrain existing draws object
unconstrained_draws <- fit_mcmc$unconstrain_draws(draws = fit_mcmc$draws())
}

}
\seealso{
\code{\link[=log_prob]{log_prob()}}, \code{\link[=grad_log_prob]{grad_log_prob()}}, \code{\link[=constrain_variables]{constrain_variables()}},
\code{\link[=unconstrain_variables]{unconstrain_variables()}}, \code{\link[=unconstrain_draws]{unconstrain_draws()}}, \code{\link[=variable_skeleton]{variable_skeleton()}},
\code{\link[=hessian]{hessian()}}
}
