% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-sampler_diagnostics}
\alias{fit-method-sampler_diagnostics}
\alias{sampler_diagnostics}
\title{Extract sampler diagnostics after MCMC}
\usage{
sampler_diagnostics(
  inc_warmup = FALSE,
  format = getOption("cmdstanr_draws_format", "draws_array")
)
}
\arguments{
\item{inc_warmup}{(logical) Should warmup draws be included? Defaults to \code{FALSE}.}

\item{format}{(string) The draws format to return. See
\link[=fit-method-draws]{draws} for details.}
}
\value{
Depends on \code{format}, but the default is a 3-D
\code{\link[posterior:draws_array]{draws_array}} object (iteration x chain x
variable). The variables for Stan's default MCMC algorithm are
\code{"accept_stat__"}, \code{"stepsize__"}, \code{"treedepth__"}, \code{"n_leapfrog__"},
\code{"divergent__"}, \code{"energy__"}.
}
\description{
Extract the values of sampler diagnostics for each iteration and
chain of MCMC. To instead get summaries of these diagnostics and associated
warning messages use the
\code{\link[=fit-method-diagnostic_summary]{$diagnostic_summary()}} method.
}
\examples{
\dontrun{
fit <- cmdstanr_example("logistic")
sampler_diagnostics <- fit$sampler_diagnostics()
str(sampler_diagnostics)

library(posterior)
as_draws_df(sampler_diagnostics)

# or specify format to get a data frame instead of calling as_draws_df
fit$sampler_diagnostics(format = "df")
}

}
\seealso{
\code{\link{CmdStanMCMC}}
}
