% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{CmdStanVB}
\alias{CmdStanVB}
\title{CmdStanVB objects}
\description{
A \code{CmdStanVB} object is the fitted model object returned by the
\code{\link[=model-method-variational]{$variational()}} method of a
\code{\link{CmdStanModel}} object.
}
\section{Methods}{
 \code{CmdStanVB} objects have the following associated methods,
all of which have their own (linked) documentation pages.
\subsection{Extract contents of fitted model object}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-draws]{$draws()}} \tab Return approximate posterior draws as a \code{\link[posterior:draws_matrix]{draws_matrix}}. \cr
   \code{\link[=fit-method-lp]{$lp()}} \tab Return the total log probability density (\code{target}) computed in the model block of the Stan program. \cr
   \code{\link[=fit-method-lp]{$lp_approx()}} \tab Return the log density of the variational approximation to the posterior. \cr
   \code{\link[=fit-method-init]{$init()}} \tab Return user-specified initial values. \cr
   \code{\link[=fit-method-metadata]{$metadata()}} \tab Return a list of metadata gathered from the CmdStan CSV files. \cr
   \code{\link[=fit-method-code]{$code()}} \tab Return Stan code as a character vector. \cr
}

}

\subsection{Summarize inferences}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-summary]{$summary()}} \tab Run \code{\link[posterior:draws_summary]{posterior::summarise_draws()}}. \cr
   \code{\link[=fit-method-cmdstan_summary]{$cmdstan_summary()}} \tab Run and print CmdStan's \code{bin/stansummary}. \cr
}

}

\subsection{Save fitted model object and temporary files}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-save_object]{$save_object()}} \tab Save fitted model object to a file. \cr
   \code{\link[=fit-method-save_output_files]{$save_output_files()}} \tab Save output CSV files to a specified location. \cr
   \code{\link[=fit-method-save_data_file]{$save_data_file()}} \tab Save JSON data file to a specified location. \cr
   \code{\link[=fit-method-save_latent_dynamics_files]{$save_latent_dynamics_files()}} \tab Save diagnostic CSV files to a specified location. \cr
}

}

\subsection{Report run times, console output, return codes}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-time]{$time()}} \tab Report the total run time. \cr
   \code{\link[=fit-method-output]{$output()}} \tab Pretty print the output that was printed to the console. \cr
   \code{\link[=fit-method-return_codes]{$return_codes()}} \tab Return the return codes from the CmdStan runs. \cr
}

}

\subsection{Expose Stan functions and additional methods to R}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-expose_functions]{$expose_functions()}} \tab Expose Stan functions for use in R. \cr
   \code{\link[=fit-method-init_model_methods]{$init_model_methods()}} \tab Expose methods for log-probability, gradients, parameter constraining and unconstraining. \cr
   \code{\link[=fit-method-log_prob]{$log_prob()}} \tab Calculate log-prob. \cr
   \code{\link[=fit-method-grad_log_prob]{$grad_log_prob()}} \tab Calculate log-prob and gradient. \cr
   \code{\link[=fit-method-hessian]{$hessian()}} \tab Calculate log-prob, gradient, and hessian. \cr
   \code{\link[=fit-method-constrain_variables]{$constrain_variables()}} \tab Transform a set of unconstrained parameter values to the constrained scale. \cr
   \code{\link[=fit-method-unconstrain_variables]{$unconstrain_variables()}} \tab Transform a set of parameter values to the unconstrained scale. \cr
   \code{\link[=fit-method-unconstrain_draws]{$unconstrain_draws()}} \tab Transform all parameter draws to the unconstrained scale. \cr
   \code{\link[=fit-method-variable_skeleton]{$variable_skeleton()}} \tab Helper function to re-structure a vector of constrained parameter values. \cr
}

}
}

\seealso{
The CmdStanR website
(\href{https://mc-stan.org/cmdstanr/}{mc-stan.org/cmdstanr}) for online
documentation and tutorials.

The Stan and CmdStan documentation:
\itemize{
\item Stan documentation: \href{https://mc-stan.org/users/documentation/}{mc-stan.org/users/documentation}
\item CmdStan User’s Guide: \href{https://mc-stan.org/docs/cmdstan-guide/}{mc-stan.org/docs/cmdstan-guide}
}

Other fitted model objects: 
\code{\link{CmdStanDiagnose}},
\code{\link{CmdStanGQ}},
\code{\link{CmdStanMCMC}},
\code{\link{CmdStanMLE}}
}
\concept{fitted model objects}
