% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{netdat}
\alias{netdat}
\title{Construct a network design matrix}
\usage{
netdat(datf, Y, X, Wi, W = NULL, panvar, tvar, factors, scaling = TRUE,
  unicons = TRUE)
}
\arguments{
\item{datf}{the entire data frame of balanced panel with NT rows of unit-time
observations}

\item{Y}{dependent variable in the data frame datf}

\item{X}{the covariate(s) generating spillovers}

\item{Wi}{other unit-varying (can be time-invariant) control variables}

\item{W}{global variables. these are only time varying but are common to all units.
eg. GDP
for individual/state-level data. Note that W has to be a vector of length T so cannot be
in the data frame datf}

\item{panvar}{the panel variable eg. unique person/firm identifiers}

\item{tvar}{time variable, eg. years}

\item{factors}{a vector of characters of factors in the data}

\item{scaling}{a logical indicating whether non-discrete covariates should be scaled by their standard deviations}

\item{unicons}{a logical indicating whether to include unit-specific constant term}
}
\value{
Y  vector of dependent variables

X  a block matrix of spillover matrix (\eqn{TN} x \eqn{N^2} )

Wm  a matrix corresponding to covariate Wi

Wf  a matrix of dummies corresponding to factors
}
\description{
This function creates the design matrix for a latent network structure using a balanced
panel
}
