% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-day.R
\name{year-month-day-arithmetic}
\alias{year-month-day-arithmetic}
\alias{add_years.clock_year_month_day}
\alias{add_quarters.clock_year_month_day}
\alias{add_months.clock_year_month_day}
\title{Arithmetic: year-month-day}
\usage{
\method{add_years}{clock_year_month_day}(x, n, ...)

\method{add_quarters}{clock_year_month_day}(x, n, ...)

\method{add_months}{clock_year_month_day}(x, n, ...)
}
\arguments{
\item{x}{\verb{[clock_year_month_day]}

A year-month-day vector.}

\item{n}{\verb{[integer / clock_duration]}

An integer vector to be converted to a duration, or a duration
corresponding to the arithmetic function being used. This corresponds
to the number of duration units to add. \code{n} may be negative to subtract
units of duration.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} after performing the arithmetic.
}
\description{
These are year-month-day methods for the
\link[=clock-arithmetic]{arithmetic generics}.
\itemize{
\item \code{add_years()}
\item \code{add_quarters()}
\item \code{add_months()}
}

Notably, \emph{you cannot add days to a year-month-day}. For day-based arithmetic,
first convert to a time point with \code{\link[=as_naive_time]{as_naive_time()}} or \code{\link[=as_sys_time]{as_sys_time()}}.
}
\details{
Adding a single quarter with \code{add_quarters()} is equivalent to adding
3 months.

\code{x} and \code{n} are recycled against each other.
}
\examples{
x <- year_month_day(2019, 1, 1)

add_years(x, 1:5)

y <- year_month_day(2019, 1, 31)

# Adding 1 month to `y` generates an invalid date
y_plus <- add_months(y, 1:2)
y_plus

# Invalid dates are fine, as long as they are eventually resolved
# by either manually resolving, or by calling `invalid_resolve()`

# Resolve by returning the previous / next valid moment in time
invalid_resolve(y_plus, invalid = "previous")
invalid_resolve(y_plus, invalid = "next")

# Manually resolve by setting to the last day of the month
invalid <- invalid_detect(y_plus)
y_plus[invalid] <- set_day(y_plus[invalid], "last")
y_plus
}
