% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-data.R
\name{check_data}
\alias{check_data}
\title{Check Data}
\usage{
check_data(
  x,
  values = NULL,
  exclusive = FALSE,
  order = FALSE,
  nrow = numeric(0),
  key = character(0),
  x_name = NULL
)
}
\arguments{
\item{x}{The object to check.}

\item{values}{A uniquely named list of atomic vectors of the column values.}

\item{exclusive}{A flag specifying whether x must only include columns named in values.}

\item{order}{A flag specifying whether the order of columns in x must match names in values.}

\item{nrow}{A flag or a whole numeric vector of the value, value range or possible values.}

\item{key}{A character vector of the columns that represent a unique key.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
An informative error if the test fails or an invisible copy of x.
}
\description{
Checks column names, values, number of rows and key for a data.frame.
}
\examples{
check_data(data.frame())
check_data(data.frame(x = 2), list(x = 1))
try(check_data(data.frame(x = 2), list(y = 1L)))
try(check_data(data.frame(x = 2), list(y = 1)))
try(check_data(data.frame(x = 2), nrow = 2))
}
\seealso{
Other check: 
\code{\link{check_dim}()},
\code{\link{check_dirs}()},
\code{\link{check_files}()},
\code{\link{check_key}()},
\code{\link{check_names}()},
\code{\link{check_values}()}
}
\concept{check}
