% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichTextContent.R
\name{enrichTextContent}
\alias{enrichTextContent}
\title{Enrich Text Content}
\usage{
enrichTextContent(Model = "gpt-4-0613", SelectedCode = TRUE, verbose = TRUE)
}
\arguments{
\item{Model}{A character string specifying the AI model to be used for text enrichment. Default is "gpt-4-0613".}

\item{SelectedCode}{A logical flag to indicate whether to read from RStudio's selected text. Default is TRUE.}

\item{verbose}{Logical flag to indicate whether to display the generated text. Default is TRUE.}
}
\value{
If SelectedCode is TRUE, the enriched text is inserted into the RStudio editor and a message "Finished!!" is returned.
        Otherwise, the enriched text is placed into the clipboard.
}
\description{
This function doubles the amount of text without changing its meaning.
   The GPT-4 model is currently recommended for text generation. It can either read from the RStudio selection or the clipboard.
}
\details{
Enrich Text Content
}
\examples{
\dontrun{
  enrichTextContent(Model = "gpt-4-0613", SelectedCode = TRUE)
}
}
\author{
Satoshi Kume
}
