% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat4R.R
\name{chat4R}
\alias{chat4R}
\title{Chat4R: Interact with GPT-3.5 (default) using OpenAI API}
\usage{
chat4R(
  content,
  Model = "gpt-3.5-turbo-16k",
  temperature = 1,
  simple = TRUE,
  fromJSON_parsed = FALSE,
  api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{content}{A string containing the user's input message.}

\item{Model}{A string specifying the GPT model to use (default: "gpt-3.5-turbo-16k").}

\item{temperature}{A numeric value controlling the randomness of the model's output (default: 1).}

\item{simple}{Logical, if TRUE, only the content of the model's message will be returned.}

\item{fromJSON_parsed}{Logical, if TRUE, content will be parsed from JSON.}

\item{api_key}{A string containing the user's OpenAI API key. Defaults to the value of the environment variable "OPENAI_API_KEY".}
}
\value{
A data frame containing the response from the GPT model.
}
\description{
This function uses the OpenAI API to interact with the
  GPT-3.5 model (default) and generates responses based on user input.
}
\details{
Chat4R Function
}
\examples{
\dontrun{
Sys.setenv(OPENAI_API_KEY = "Your API key")
response <- chat4R("What is the capital of France?")
response
}
}
\author{
Satoshi Kume
}
