% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_calib.R
\name{plot.calib_mlr}
\alias{plot.calib_mlr}
\title{Plots calibration scatter plots for objects of class \code{calib_mlr} estimated using
using \code{\link{calib_msm}}.}
\usage{
\method{plot}{calib_mlr}(
  x,
  ...,
  combine = TRUE,
  ncol = NULL,
  nrow = NULL,
  size.point = 0.5,
  size.text = 12,
  transparency.plot = 0.25,
  marg.density = FALSE,
  marg.density.size = 5,
  marg.density.type = "density",
  marg.rug = FALSE,
  marg.rug.transparency = 0.1,
  titles.include = TRUE,
  titles = NULL,
  axis.titles.x = NULL,
  axis.titles.text.x = "Predicted risk",
  axis.titles.y = NULL,
  axis.titles.text.y = "Observed risk"
)
}
\arguments{
\item{x}{Object of class \code{calib_mlr} generated from \code{\link{calib_msm}}}

\item{...}{Other}

\item{combine}{Whether to combine into one plot using ggarrange, or return as a list of individual plots}

\item{ncol}{Number of columns for combined calibration plot}

\item{nrow}{Number of rows for combined calibration plot}

\item{size.point}{Size of points in scatter plot}

\item{size.text}{Size of text in plot}

\item{transparency.plot}{Degree of transparency for points in the calibration scatter plot}

\item{marg.density}{Whether to produce marginal density plots TRUE/FALSE}

\item{marg.density.size}{Size of the main plot relative to the density plots (see \code{\link[ggExtra]{ggMarginal}})}

\item{marg.density.type}{What type of marginal plot to show (see \code{\link[ggExtra]{ggMarginal}})}

\item{marg.rug}{Whether to produce marginal rug plots TRUE/FALSE}

\item{marg.rug.transparency}{Degree of transparency for the density rug plot along each axis}

\item{titles.include}{Whether to include titles for each individual calibration plots}

\item{titles}{Vector of titles for the calibration plots. Defaults to "State k" for each plot.}

\item{axis.titles.x}{Position of plots for which to include title on x-axis}

\item{axis.titles.text.x}{x-axis title}

\item{axis.titles.y}{Position of plots for which to include title on y-axis}

\item{axis.titles.text.y}{y-axis title}
}
\value{
If \code{combine = TRUE}, returns an object of classes \code{gg}, \code{ggplot}, and \code{ggarrange},
as all ggplots have been combined into one object. If \code{combine = FALSE}, returns an object of
class \code{list}, each element containing an object of class \code{gg} and \code{ggplot}.
}
\description{
Plots calibration scatter plots for the transition probabilities of a multistate model
estimated using the MLR-IPCW approach.
}
\examples{
# Using competing risks data out of initial state (see vignette: ... -in-competing-risk-setting).
# Estimate and plot MLR-IPCW calibration scatter plots for the predicted transition
# probabilities at time t = 1826, when predictions were made at time
# s = 0 in state j = 1. These predicted transition probabilities are stored in tp.cmprsk.j0.

# To minimise example time we reduce the datasets to 150 individuals.
# Extract the predicted transition probabilities out of state j = 1 for first 150 individuals
tp.pred <- tp.cmprsk.j0 |>
 dplyr::filter(id \%in\% 1:150) |>
 dplyr::select(any_of(paste("pstate", 1:6, sep = "")))
# Reduce ebmtcal to first 150 individuals
ebmtcal <- ebmtcal |> dplyr::filter(id \%in\% 1:150)
# Reduce msebmtcal.cmprsk to first 150 individuals
msebmtcal.cmprsk <- msebmtcal.cmprsk |> dplyr::filter(id \%in\% 1:150)

# Now estimate the observed event probabilities for each possible transition.
dat.calib <-
calib_msm(data.mstate = msebmtcal.cmprsk,
 data.raw = ebmtcal,
 j=1,
 s=0,
 t = 1826,
 tp.pred = tp.pred,
 calib.type = "mlr",
 w.covs = c("year", "agecl", "proph", "match"),
 mlr.ps.int = 2,
 mlr.degree = 2)

 # These are then plotted
 plot(dat.calib, combine = TRUE, nrow = 2, ncol = 3)

}
