% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{VARtoVMA}
\alias{VARtoVMA}
\title{Convert VAR to VMA(infinite)}
\usage{
VARtoVMA(object, lag_max)
}
\arguments{
\item{object}{A \code{varlse} object}

\item{lag_max}{Maximum lag for VMA}
}
\value{
VMA coefficient of k(lag-max + 1) x k dimension
}
\description{
Convert VAR process to infinite vector MA process
}
\details{
Let VAR(p) be stable.
\deqn{Y_t = c + \sum_{j = 0} W_j Z_{t - j}}
For VAR coefficient \eqn{B_1, B_2, \ldots, B_p},
\deqn{I = (W_0 + W_1 L + W_2 L^2 + \cdots + ) (I - B_1 L - B_2 L^2 - \cdots - B_p L^p)}
Recursively,
\deqn{W_0 = I}
\deqn{W_1 = W_0 B_1 (W_1^T = B_1^T W_0^T)}
\deqn{W_2 = W_1 B_1 + W_0 B_2 (W_2^T = B_1^T W_1^T + B_2^T W_0^T)}
\deqn{W_j = \sum_{j = 1}^k W_{k - j} B_j (W_j^T = \sum_{j = 1}^k B_j^T W_{k - j}^T)}
}
\references{
Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.
}
