% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-bvharsp.R, R/summary-sparse.R
\name{print.summary.bvharsp}
\alias{print.summary.bvharsp}
\alias{knit_print.summary.ssvsmod}
\alias{summary.ssvsmod}
\alias{summary.hsmod}
\title{Summarizing BVAR and BVHAR with Shrinkage Priors}
\usage{
\method{print}{summary.bvharsp}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{summary.ssvsmod}(x, ...)

\method{summary}{ssvsmod}(object, method = c("pip", "ci"), threshold = 0.5, level = 0.05, ...)

\method{summary}{hsmod}(object, method = c("ci", "pip"), threshold = 0.5, level = 0.05, ...)
}
\arguments{
\item{x}{\code{summary.ssvsmod} object}

\item{digits}{digit option to print}

\item{...}{not used}

\item{object}{\code{ssvsmod} object}

\item{method}{Use PIP (\code{"pip"}) or credible interval (\code{"ci"}).}

\item{threshold}{Threshold for posterior inclusion probability}

\item{level}{Specify alpha of credible interval level 100(1 - alpha) percentage. By default, \code{.05}.}
}
\value{
\code{summary.ssvsmod} object

\code{summary.hsmod} object
}
\description{
Conduct variable selection.
}
\references{
George, E. I., & McCulloch, R. E. (1993). \emph{Variable Selection via Gibbs Sampling}. Journal of the American Statistical Association, 88(423), 881–889.

George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions}. Journal of Econometrics, 142(1), 553–580.

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267–358.

O’Hara, R. B., & Sillanpää, M. J. (2009). \emph{A review of Bayesian variable selection methods: what, how and which}. Bayesian Analysis, 4(1), 85–117.
}
