% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{axe-formula}
\alias{axe-formula}
\alias{axe_env.formula}
\title{Axing formulas.}
\usage{
\method{axe_env}{formula}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed formula object.
}
\description{
formulas might capture an environment from the modeling development
process that carries objects that will not be used for any post-
estimation activities.
}
\examples{
wrapped_formula <- function() {
  some_junk_in_environment <- runif(1e6)
  ex <- as.formula(paste("y ~", paste(LETTERS, collapse = "+")))
  return(ex)
}

lobstr::obj_size(wrapped_formula())
lobstr::obj_size(butcher(wrapped_formula()))

wrapped_quosure <- function() {
  some_junk_in_environment <- runif(1e6)
  out <- rlang::quo(x)
  return(out)
}
lobstr::obj_size(wrapped_quosure())
lobstr::obj_size(butcher(wrapped_quosure))

}
