% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildGLMMadaptive}
\alias{buildGLMMadaptive}
\title{Use \code{buildmer} to fit generalized linear mixed models using \code{mixed_model} from package \code{GLMMadaptive}}
\usage{
buildGLMMadaptive(
  formula,
  data = NULL,
  family,
  buildmerControl = buildmerControl()
)
}
\arguments{
\item{formula}{A formula specifying both fixed and random effects using \code{lme4} syntax. (Unlike \code{mixed_model}, \code{buildGLMMadaptive} does not use a separate \code{random} argument!)}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{buildmerControl}{Control arguments for buildmer --- see the general documentation under \code{\link{buildmerControl}}}
}
\description{
Use \code{buildmer} to fit generalized linear mixed models using \code{mixed_model} from package \code{GLMMadaptive}
}
\details{
The fixed and random effects are to be passed as a single formula in \emph{\code{lme4} format}. This is internally split up into the appropriate \code{fixed} and \code{random} parts.

As GLMMadaptive can only fit models with a single random-effect grouping factor, having multiple \emph{different} grouping factors will raise an error.

If multiple \emph{identical} random-effect grouping factors are provided, they will be concatenated into a single grouping factor using the double-bar syntax, causing GLMMadaptive to assume a diagonal random-effects covariance matrix. In other words, \code{(1|g) + (0+x|g)} will correctly be treated as diagonal, but note the caveat: \code{(a|g) + (b|g)} will also be treated as fully diagonal, even if \code{a} and \code{b} are factors which might still have had correlations between their individual levels! This is a limitation of both GLMMadaptive and buildmer's approach to handling double bars.
}
\examples{
\donttest{
if (requireNamespace('GLMMadaptive')) {
# nonsensical model given these data
model <- buildGLMMadaptive(stress ~ vowel + (vowel|participant),
       family=binomial,data=vowels,buildmerControl=list(args=list(nAGQ=1)))
# or with double-bar syntax for a diagonal r.e. cov. matrix
model <- buildGLMMadaptive(stress ~ vowel + (vowel||participant),
       family=binomial,data=vowels,buildmerControl=list(args=list(nAGQ=1)))
}
}
}
\seealso{
\code{\link{buildmer-package}}
}
