% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/brr.R
\name{PriorAndPosterior}
\alias{PriorAndPosterior}
\alias{dpost}
\alias{dprior}
\alias{ppost}
\alias{pprior}
\alias{qpost}
\alias{qprior}
\alias{rpost}
\alias{rprior}
\alias{spost}
\alias{sprior}
\title{Prior and posterior distributions}
\usage{
dprior(model, parameter, ...)

pprior(model, parameter, ...)

qprior(model, parameter, ...)

rprior(model, parameter, ...)

sprior(model, parameter, ...)

dpost(model, parameter, ...)

ppost(model, parameter, ...)

qpost(model, parameter, ...)

rpost(model, parameter, ...)

spost(model, parameter, ...)
}
\arguments{
\item{model}{an object of class \code{brr} (see \code{\link{Brr}})}

\item{parameter}{a character string among \code{mu}, \code{phi}, \code{lambda}, \code{x}, \code{y}}

\item{...}{the first argument of the function called}
}
\description{
Generic functions for prior and posterior distributions


}
\examples{
model <- Brr(a=2, b=4)
dprior(model, "mu", 1:3)
# the same:
dprior_mu(mu=1:3, a=2, b=4)
\dontrun{
dprior(model, "lambda", 1:3)}
model <- model(c=4, d=5, S=10, T=10)
dprior(model, "lambda", 1:3)
model <- model(x=5, y=10)
ppost(model, "phi", 1)
model <- Brr()
\dontrun{
ppost(model, "phi", 1)}
model <- model(x=5, y=10, S=3, T=10)
ppost(model, "phi", 1)
}

