% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{covEffectOR2}
\alias{covEffectOR2}
\title{Covariate effect in the OR2 model}
\usage{
covEffectOR2(modelOR2, y, xMat1, xMat2, gammacp2, p, verbose)
}
\arguments{
\item{modelOR2}{output from the quantregOR2 function.}

\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{xMat1}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.
If the covariate of interest is continuous, then the column for the covariate of interest remains unchanged.
If it is an indicator variable then replace the column for the covariate of interest with a
column of zeros.}

\item{xMat2}{covariate matrix x with suitable modification to an independent variable including a column of ones with
or without column names. If the covariate of interest is continuous, then add the incremental change
to each observation in the column for the covariate of interest. If the covariate is an indicator variable,
then replace the column for the covariate of interest with a column of ones.}

\item{gammacp2}{one and only cut-point other than 0.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{verbose}{whether to print the final output and provide additional information or not, default is TRUE.}
}
\value{
Returns a list with components:
\item{\code{avgDiffProb}: }{vector with change in predicted
probability for each outcome category.}
}
\description{
This function computes the average covariate effect for different
outcomes of the OR2 model at a specified quantile. The covariate
effects are calculated marginally of the parameters and the remaining covariates.
}
\details{
This function computes the average covariate effect for different
outcomes of the OR2 model at a specified quantile. The covariate
effects are computed, using the Gibbs draws, marginally of the parameters
and the remaining covariates.
}
\examples{
set.seed(101)
data("data25j3")
y <- data25j3$y
xMat1 <- data25j3$x
k <- dim(xMat1)[2]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
n0 <- 5
d0 <- 8
output <- quantregOR2(y, xMat1, b0, B0, n0, d0, gammacp2 = 3,
burn = 10, mcmc = 40, p = 0.25, accutoff = 0.5, maxlags = 400, verbose = FALSE)
xMat2 <- xMat1
xMat2[,3] <- xMat2[,3] + 0.02
res <- covEffectOR2(output, y, xMat1, xMat2, gammacp2 = 3, p = 0.25, verbose = TRUE)

# Summary of Covariate Effect:

#               Covariate Effect
# Category_1          -0.0073
# Category_2          -0.0030
# Category_3           0.0103

}
\references{
Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). `"Fitting and Comparison of Models for Multivariate Ordinal Outcomes."`
Advances in Econometrics: Bayesian Econometrics, 23: 115`-`156. DOI: 10.1016/S0731-9053(08)23004-5

Jeliazkov, I., and Rahman, M. A. (2012). `"Binary and Ordinal Data Analysis in Economics: Modeling and Estimation"`
in Mathematical Modeling with Multidisciplinary
Applications, edited by X.S. Yang, 123-150. John Wiley `&` Sons Inc, Hoboken, New Jersey. DOI: 10.1002/9781118462706.ch6
}
