% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_split.R
\name{mr_split}
\alias{mr_split}
\title{Split the whole dataset into samll subsets and conduct MCMC sampling parallelly and combine the posterior.}
\usage{
mr_split(
  df,
  selectsnp,
  exposureName,
  outcomeName,
  mr_model = "linear",
  prior = "horseshoe",
  init = "median",
  n.iter = 4000,
  n.chain = 4,
  n.split = 4
)
}
\arguments{
\item{df}{a data frame which contains data of IVs, specified exposure and outcome.}

\item{selectsnp}{a vector of string containing the column names of df corresponding to the IV used in MR.}

\item{exposureName}{a string which is a column name of df corresponding to the exposure studied.}

\item{outcomeName}{a string which is a column name of df corresponding to the outcome studied.}

\item{mr_model}{model for MR. Possible values are "linear" or "logit". Default is "linear".}

\item{prior}{a string represented shrinkage prior used in estimation. It can be "horseshoe", "lasso", "hyperlasso", "spikeslabBernoulli", "spikeslabUniform". Default is "horseshoe".}

\item{init}{the init value of theta for MCMC estimation. It can be a specific numeric or a string of "TSLS", "median", "egger" and "ivw", which means the initial value of the iteration will be calculated automatically by the above method. Default is "median".}

\item{n.iter}{an integer standing for the number of iterations. Default is 5000.}

\item{n.chain}{the number of chains in MCMC sampling. Default is 4.}

\item{n.split}{the number of subsets to be split. Default is 4.}
}
\value{
a list containing:
  \item{betaList}{a vector cantaining the combined posterior of the causal parameter of interest using MCMC sampling.}
  \item{mean}{the mean estimate of the causal parameter.}
  \item{se}{the standard error of the estimation.}
  \item{lower}{the lower boundary of the 95\% CI of the causal estimation.}
  \item{upper}{the upper boundary of the 95\% CI of the causal estimation.}
  \item{Rhat}{an indicator to measure the convergence (at convergence, Rhat <= 1.1).}
}
\description{
Split the whole dataset into samll subsets and conduct MCMC sampling parallelly and combine the posterior.
}
\examples{
n <- 2000
p <- 200
snps <- replicate(p,sample(0:2,n,replace = TRUE))
snps <- apply(snps,2,as.numeric)
snpname <- paste0("g",1:p)
df <- as.data.frame(snps)
colnames(df) <- snpname
truesnp <- paste0("g",sample(1:p,50))
df$x <- as.matrix(df[,truesnp])\%*\%rnorm(50,0.05,0.05)+rnorm(n,0,1)
df$y <- 0.5*df$x+rnorm(n,0,1)
model <- mr_split(df,truesnp,"x","y",n.split=4)

}
