% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtnorm.R
\name{rtnorm}
\alias{rtnorm}
\title{Random univariate truncated normal generator}
\usage{
rtnorm(l = -Inf, u = Inf)
}
\arguments{
\item{l}{lower bound}

\item{u}{upper bound}
}
\value{
A single draw from a univariate standard normal truncated between l and u.
}
\description{
Random univariate truncated normal generator
}
\details{
The truncated standard univaraite random variable is generated with the mixed sampler of Li and Ghosh (2015).
}
\examples{
rtnorm(l=0)  # bounded below at 0
rtnorm(u=0)  # bounded above at 0
rtnorm(l=0,u=1)  # bounded between 0 and 1

}
\references{
Li Y. and Ghosh S.K. (2015) "Efficient Sampling Methods for Truncated Multivariate Normal and Student-t Distributions Subject to Linear Inequality Constraints." Journal of Statistical Theory and Practice. 9(4) 712-732.
}
