// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_forecastDCC_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'forecastDCC', line 42, column 0 to column 16)",
                                                      " (in 'forecastDCC', line 47, column 0 to column 41)",
                                                      " (in 'forecastDCC', line 48, column 0 to column 43)",
                                                      " (in 'forecastDCC', line 54, column 0 to column 16)",
                                                      " (in 'forecastDCC', line 56, column 2 to column 23)",
                                                      " (in 'forecastDCC', line 59, column 2 to column 17)",
                                                      " (in 'forecastDCC', line 60, column 2 to column 36)",
                                                      " (in 'forecastDCC', line 61, column 2 to column 47)",
                                                      " (in 'forecastDCC', line 63, column 2 to column 32)",
                                                      " (in 'forecastDCC', line 64, column 2 to column 40)",
                                                      " (in 'forecastDCC', line 65, column 2 to column 20)",
                                                      " (in 'forecastDCC', line 67, column 2 to column 28)",
                                                      " (in 'forecastDCC', line 68, column 2 to column 29)",
                                                      " (in 'forecastDCC', line 69, column 2 to column 27)",
                                                      " (in 'forecastDCC', line 70, column 2 to column 25)",
                                                      " (in 'forecastDCC', line 71, column 2 to column 24)",
                                                      " (in 'forecastDCC', line 72, column 2 to column 29)",
                                                      " (in 'forecastDCC', line 73, column 2 to column 29)",
                                                      " (in 'forecastDCC', line 74, column 2 to column 24)",
                                                      " (in 'forecastDCC', line 78, column 2 to column 43)",
                                                      " (in 'forecastDCC', line 79, column 2 to column 41)",
                                                      " (in 'forecastDCC', line 80, column 2 to column 45)",
                                                      " (in 'forecastDCC', line 81, column 2 to column 43)",
                                                      " (in 'forecastDCC', line 82, column 2 to column 46)",
                                                      " (in 'forecastDCC', line 83, column 2 to column 44)",
                                                      " (in 'forecastDCC', line 84, column 2 to column 42)",
                                                      " (in 'forecastDCC', line 85, column 2 to column 42)",
                                                      " (in 'forecastDCC', line 86, column 2 to column 40)",
                                                      " (in 'forecastDCC', line 87, column 2 to column 41)",
                                                      " (in 'forecastDCC', line 88, column 2 to column 46)",
                                                      " (in 'forecastDCC', line 89, column 2 to column 41)",
                                                      " (in 'forecastDCC', line 90, column 2 to column 46)",
                                                      " (in 'forecastDCC', line 93, column 2 to column 52)",
                                                      " (in 'forecastDCC', line 96, column 2 to column 33)",
                                                      " (in 'forecastDCC', line 97, column 2 to column 35)",
                                                      " (in 'forecastDCC', line 98, column 2 to column 35)",
                                                      " (in 'forecastDCC', line 101, column 2 to column 63)",
                                                      " (in 'forecastDCC', line 102, column 2 to column 62)",
                                                      " (in 'forecastDCC', line 103, column 2 to column 62)",
                                                      " (in 'forecastDCC', line 104, column 2 to column 62)",
                                                      " (in 'forecastDCC', line 105, column 2 to column 62)",
                                                      " (in 'forecastDCC', line 106, column 2 to column 62)",
                                                      " (in 'forecastDCC', line 107, column 2 to column 62)",
                                                      " (in 'forecastDCC', line 108, column 2 to column 70)",
                                                      " (in 'forecastDCC', line 110, column 2 to column 60)",
                                                      " (in 'forecastDCC', line 112, column 2 to column 52)",
                                                      " (in 'forecastDCC', line 113, column 2 to column 52)",
                                                      " (in 'forecastDCC', line 114, column 2 to column 52)",
                                                      " (in 'forecastDCC', line 116, column 2 to column 58)",
                                                      " (in 'forecastDCC', line 117, column 2 to column 54)",
                                                      " (in 'forecastDCC', line 118, column 2 to column 54)",
                                                      " (in 'forecastDCC', line 119, column 2 to column 54)",
                                                      " (in 'forecastDCC', line 120, column 2 to column 62)",
                                                      " (in 'forecastDCC', line 121, column 2 to column 54)",
                                                      " (in 'forecastDCC', line 129, column 6 to column 83)",
                                                      " (in 'forecastDCC', line 128, column 35 to line 130, column 5)",
                                                      " (in 'forecastDCC', line 128, column 11 to line 130, column 5)",
                                                      " (in 'forecastDCC', line 127, column 6 to column 23)",
                                                      " (in 'forecastDCC', line 126, column 28 to line 128, column 5)",
                                                      " (in 'forecastDCC', line 126, column 4 to line 130, column 5)",
                                                      " (in 'forecastDCC', line 132, column 6 to column 22)",
                                                      " (in 'forecastDCC', line 133, column 6 to column 22)",
                                                      " (in 'forecastDCC', line 134, column 6 to column 22)",
                                                      " (in 'forecastDCC', line 137, column 1 to column 55)",
                                                      " (in 'forecastDCC', line 138, column 1 to column 51)",
                                                      " (in 'forecastDCC', line 136, column 33 to line 139, column 7)",
                                                      " (in 'forecastDCC', line 136, column 6 to line 139, column 7)",
                                                      " (in 'forecastDCC', line 142, column 7 to column 57)",
                                                      " (in 'forecastDCC', line 141, column 33 to line 143, column 7)",
                                                      " (in 'forecastDCC', line 141, column 6 to line 143, column 7)",
                                                      " (in 'forecastDCC', line 148, column 7 to column 56)",
                                                      " (in 'forecastDCC', line 147, column 34 to line 149, column 7)",
                                                      " (in 'forecastDCC', line 147, column 13 to line 149, column 7)",
                                                      " (in 'forecastDCC', line 146, column 1 to column 72)",
                                                      " (in 'forecastDCC', line 145, column 27 to line 147, column 7)",
                                                      " (in 'forecastDCC', line 145, column 6 to line 149, column 7)",
                                                      " (in 'forecastDCC', line 150, column 6 to column 34)",
                                                      " (in 'forecastDCC', line 131, column 18 to line 151, column 5)",
                                                      " (in 'forecastDCC', line 131, column 4 to line 151, column 5)",
                                                      " (in 'forecastDCC', line 152, column 4 to column 75)",
                                                      " (in 'forecastDCC', line 153, column 4 to column 88)",
                                                      " (in 'forecastDCC', line 154, column 4 to column 49)",
                                                      " (in 'forecastDCC', line 155, column 4 to column 53)",
                                                      " (in 'forecastDCC', line 158, column 4 to column 68)",
                                                      " (in 'forecastDCC', line 165, column 2 to column 58)",
                                                      " (in 'forecastDCC', line 164, column 33 to line 166, column 2)",
                                                      " (in 'forecastDCC', line 164, column 8 to line 166, column 2)",
                                                      " (in 'forecastDCC', line 163, column 2 to column 51)",
                                                      " (in 'forecastDCC', line 162, column 25 to line 164, column 2)",
                                                      " (in 'forecastDCC', line 162, column 0 to line 166, column 2)",
                                                      " (in 'forecastDCC', line 124, column 52 to line 182, column 3)",
                                                      " (in 'forecastDCC', line 124, column 2 to line 182, column 3)",
                                                      " (in 'forecastDCC', line 183, column 2 to column 62)",
                                                      " (in 'forecastDCC', line 184, column 2 to column 58)",
                                                      " (in 'forecastDCC', line 185, column 2 to column 58)",
                                                      " (in 'forecastDCC', line 186, column 2 to column 60)",
                                                      " (in 'forecastDCC', line 195, column 6 to column 96)",
                                                      " (in 'forecastDCC', line 194, column 22 to line 196, column 5)",
                                                      " (in 'forecastDCC', line 194, column 4 to line 196, column 5)",
                                                      " (in 'forecastDCC', line 193, column 33 to line 197, column 3)",
                                                      " (in 'forecastDCC', line 193, column 9 to line 197, column 3)",
                                                      " (in 'forecastDCC', line 191, column 6 to column 89)",
                                                      " (in 'forecastDCC', line 190, column 22 to line 192, column 5)",
                                                      " (in 'forecastDCC', line 190, column 4 to line 192, column 5)",
                                                      " (in 'forecastDCC', line 189, column 26 to line 193, column 3)",
                                                      " (in 'forecastDCC', line 189, column 2 to line 197, column 3)",
                                                      " (in 'forecastDCC', line 188, column 22 to line 198, column 2)",
                                                      " (in 'forecastDCC', line 188, column 0 to line 198, column 2)",
                                                      " (in 'forecastDCC', line 3, column 0 to column 15)",
                                                      " (in 'forecastDCC', line 4, column 0 to column 16)",
                                                      " (in 'forecastDCC', line 5, column 0 to column 15)",
                                                      " (in 'forecastDCC', line 6, column 0 to column 15)",
                                                      " (in 'forecastDCC', line 7, column 6 to column 7)",
                                                      " (in 'forecastDCC', line 7, column 16 to column 18)",
                                                      " (in 'forecastDCC', line 7, column 0 to column 24)",
                                                      " (in 'forecastDCC', line 8, column 6 to column 7)",
                                                      " (in 'forecastDCC', line 8, column 16 to column 18)",
                                                      " (in 'forecastDCC', line 8, column 0 to column 23)",
                                                      " (in 'forecastDCC', line 9, column 0 to column 35)",
                                                      " (in 'forecastDCC', line 10, column 0 to column 36)",
                                                      " (in 'forecastDCC', line 11, column 0 to column 19)",
                                                      " (in 'forecastDCC', line 12, column 6 to column 11)",
                                                      " (in 'forecastDCC', line 12, column 20 to column 22)",
                                                      " (in 'forecastDCC', line 12, column 0 to column 29)",
                                                      " (in 'forecastDCC', line 13, column 6 to column 11)",
                                                      " (in 'forecastDCC', line 13, column 20 to column 22)",
                                                      " (in 'forecastDCC', line 13, column 0 to column 35)",
                                                      " (in 'forecastDCC', line 14, column 0 to column 42)",
                                                      " (in 'forecastDCC', line 17, column 9 to column 25)",
                                                      " (in 'forecastDCC', line 17, column 27 to column 29)",
                                                      " (in 'forecastDCC', line 17, column 2 to column 36)",
                                                      " (in 'forecastDCC', line 20, column 6 to column 7)",
                                                      " (in 'forecastDCC', line 20, column 16 to column 18)",
                                                      " (in 'forecastDCC', line 20, column 20 to column 22)",
                                                      " (in 'forecastDCC', line 20, column 0 to column 29)",
                                                      " (in 'forecastDCC', line 21, column 0 to column 29)",
                                                      " (in 'forecastDCC', line 22, column 0 to column 19)",
                                                      " (in 'forecastDCC', line 25, column 2 to column 33)",
                                                      " (in 'forecastDCC', line 27, column 2 to column 33)",
                                                      " (in 'forecastDCC', line 29, column 4 to column 30)",
                                                      " (in 'forecastDCC', line 28, column 2 to line 29, column 30)",
                                                      " (in 'forecastDCC', line 24, column 15 to line 30, column 2)",
                                                      " (in 'forecastDCC', line 24, column 0 to line 30, column 2)",
                                                      " (in 'forecastDCC', line 33, column 4 to column 38)",
                                                      " (in 'forecastDCC', line 32, column 24 to line 34, column 3)",
                                                      " (in 'forecastDCC', line 32, column 2 to line 34, column 3)",
                                                      " (in 'forecastDCC', line 36, column 4 to column 34)",
                                                      " (in 'forecastDCC', line 35, column 20 to line 37, column 3)",
                                                      " (in 'forecastDCC', line 35, column 2 to line 37, column 3)",
                                                      " (in 'forecastDCC', line 42, column 7 to column 9)",
                                                      " (in 'forecastDCC', line 47, column 30 to column 32)",
                                                      " (in 'forecastDCC', line 47, column 33 to column 35)",
                                                      " (in 'forecastDCC', line 48, column 30 to column 32)",
                                                      " (in 'forecastDCC', line 48, column 33 to column 35)",
                                                      " (in 'forecastDCC', line 54, column 7 to column 9)",
                                                      " (in 'forecastDCC', line 59, column 9 to column 11)",
                                                      " (in 'forecastDCC', line 60, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 60, column 28 to column 30)",
                                                      " (in 'forecastDCC', line 61, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 61, column 39 to column 41)",
                                                      " (in 'forecastDCC', line 65, column 14 to column 16)",
                                                      " (in 'forecastDCC', line 67, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 67, column 22 to column 24)",
                                                      " (in 'forecastDCC', line 68, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 68, column 23 to column 25)",
                                                      " (in 'forecastDCC', line 69, column 8 to column 11)",
                                                      " (in 'forecastDCC', line 69, column 20 to column 22)",
                                                      " (in 'forecastDCC', line 70, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 70, column 18 to column 20)",
                                                      " (in 'forecastDCC', line 71, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 71, column 18 to column 20)",
                                                      " (in 'forecastDCC', line 72, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 72, column 22 to column 24)",
                                                      " (in 'forecastDCC', line 73, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 73, column 18 to column 20)",
                                                      " (in 'forecastDCC', line 74, column 8 to column 9)",
                                                      " (in 'forecastDCC', line 74, column 18 to column 20)",
                                                      " (in 'forecastDCC', line 78, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 78, column 33 to column 35)",
                                                      " (in 'forecastDCC', line 79, column 8 to column 13)",
                                                      " (in 'forecastDCC', line 79, column 22 to column 24)",
                                                      " (in 'forecastDCC', line 80, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 80, column 37 to column 39)",
                                                      " (in 'forecastDCC', line 81, column 8 to column 13)",
                                                      " (in 'forecastDCC', line 81, column 26 to column 28)",
                                                      " (in 'forecastDCC', line 82, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 82, column 38 to column 40)",
                                                      " (in 'forecastDCC', line 83, column 8 to column 13)",
                                                      " (in 'forecastDCC', line 83, column 27 to column 29)",
                                                      " (in 'forecastDCC', line 84, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 84, column 33 to column 35)",
                                                      " (in 'forecastDCC', line 85, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 85, column 33 to column 35)",
                                                      " (in 'forecastDCC', line 86, column 8 to column 13)",
                                                      " (in 'forecastDCC', line 86, column 22 to column 24)",
                                                      " (in 'forecastDCC', line 87, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 87, column 33 to column 35)",
                                                      " (in 'forecastDCC', line 88, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 88, column 37 to column 39)",
                                                      " (in 'forecastDCC', line 89, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 89, column 33 to column 35)",
                                                      " (in 'forecastDCC', line 90, column 8 to column 24)",
                                                      " (in 'forecastDCC', line 90, column 33 to column 35)",
                                                      " (in 'forecastDCC', line 93, column 8 to column 37)",
                                                      " (in 'forecastDCC', line 96, column 8 to column 10)",
                                                      " (in 'forecastDCC', line 97, column 8 to column 10)",
                                                      " (in 'forecastDCC', line 98, column 8 to column 10)"};
#include <stan_meta_header.hpp>
class model_forecastDCC final : public model_base_crtp<model_forecastDCC> {
private:
  int T;
  int nt;
  int Q;
  int P;
  std::vector<Eigen::Matrix<double, -1, 1>> rts;
  std::vector<Eigen::Matrix<double, -1, 1>> xC;
  int distribution;
  int meanstructure;
  int ahead;
  std::vector<Eigen::Matrix<double, -1, 1>> xC_p;
  std::vector<Eigen::Matrix<double, -1, 1>> future_rts;
  int compute_log_lik;
  Eigen::Matrix<double, -1, -1> xC_c;
  std::vector<Eigen::Matrix<double, -1, -1>> xC_m;
  int xC_marker;
  double cp;
  int rr_1dim__;
  int rts_p_1dim__;
  int H_p_1dim__;
  int R_p_1dim__;
  int rr_p_1dim__;
  int mu_p_1dim__;
  int D_p_1dim__;
  int Qr_p_1dim__;
  int u_p_1dim__;
  int Qr_sdi_p_1dim__;
  int log_lik_1dim__;
 
public:
  ~model_forecastDCC() { }
  
  inline std::string model_name() const final { return "model_forecastDCC"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_forecastDCC(stan::io::var_context& context__,
                    unsigned int random_seed__ = 0,
                    std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_forecastDCC_namespace::model_forecastDCC";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 109;
      context__.validate_dims("data initialization","T","int",
          context__.to_vec());
      T = std::numeric_limits<int>::min();
      
      current_statement__ = 109;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 109;
      current_statement__ = 109;
      check_greater_or_equal(function__, "T", T, 2);
      current_statement__ = 110;
      context__.validate_dims("data initialization","nt","int",
          context__.to_vec());
      nt = std::numeric_limits<int>::min();
      
      current_statement__ = 110;
      nt = context__.vals_i("nt")[(1 - 1)];
      current_statement__ = 110;
      current_statement__ = 110;
      check_greater_or_equal(function__, "nt", nt, 2);
      current_statement__ = 111;
      context__.validate_dims("data initialization","Q","int",
          context__.to_vec());
      Q = std::numeric_limits<int>::min();
      
      current_statement__ = 111;
      Q = context__.vals_i("Q")[(1 - 1)];
      current_statement__ = 111;
      current_statement__ = 111;
      check_greater_or_equal(function__, "Q", Q, 1);
      current_statement__ = 112;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 112;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 112;
      current_statement__ = 112;
      check_greater_or_equal(function__, "P", P, 1);
      current_statement__ = 113;
      validate_non_negative_index("rts", "T", T);
      current_statement__ = 114;
      validate_non_negative_index("rts", "nt", nt);
      current_statement__ = 115;
      context__.validate_dims("data initialization","rts","double",
          context__.to_vec(T, nt));
      rts = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rts_flat__;
        current_statement__ = 115;
        assign(rts_flat__, nil_index_list(), context__.vals_r("rts"),
          "assigning variable rts_flat__");
        current_statement__ = 115;
        pos__ = 1;
        current_statement__ = 115;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 115;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 115;
            assign(rts,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rts_flat__[(pos__ - 1)], "assigning variable rts");
            current_statement__ = 115;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 116;
      validate_non_negative_index("xC", "T", T);
      current_statement__ = 117;
      validate_non_negative_index("xC", "nt", nt);
      current_statement__ = 118;
      context__.validate_dims("data initialization","xC","double",
          context__.to_vec(T, nt));
      xC = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(xC, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xC_flat__;
        current_statement__ = 118;
        assign(xC_flat__, nil_index_list(), context__.vals_r("xC"),
          "assigning variable xC_flat__");
        current_statement__ = 118;
        pos__ = 1;
        current_statement__ = 118;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 118;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 118;
            assign(xC,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xC_flat__[(pos__ - 1)], "assigning variable xC");
            current_statement__ = 118;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 119;
      context__.validate_dims("data initialization","distribution","int",
          context__.to_vec());
      distribution = std::numeric_limits<int>::min();
      
      current_statement__ = 119;
      distribution = context__.vals_i("distribution")[(1 - 1)];
      current_statement__ = 119;
      current_statement__ = 119;
      check_greater_or_equal(function__, "distribution", distribution, 0);
      current_statement__ = 119;
      current_statement__ = 119;
      check_less_or_equal(function__, "distribution", distribution, 1);
      current_statement__ = 120;
      context__.validate_dims("data initialization","meanstructure","int",
          context__.to_vec());
      meanstructure = std::numeric_limits<int>::min();
      
      current_statement__ = 120;
      meanstructure = context__.vals_i("meanstructure")[(1 - 1)];
      current_statement__ = 120;
      current_statement__ = 120;
      check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
      current_statement__ = 120;
      current_statement__ = 120;
      check_less_or_equal(function__, "meanstructure", meanstructure, 2);
      current_statement__ = 121;
      context__.validate_dims("data initialization","ahead","int",
          context__.to_vec());
      ahead = std::numeric_limits<int>::min();
      
      current_statement__ = 121;
      ahead = context__.vals_i("ahead")[(1 - 1)];
      current_statement__ = 121;
      current_statement__ = 121;
      check_greater_or_equal(function__, "ahead", ahead, 1);
      current_statement__ = 122;
      validate_non_negative_index("xC_p", "ahead", ahead);
      current_statement__ = 123;
      validate_non_negative_index("xC_p", "nt", nt);
      current_statement__ = 124;
      context__.validate_dims("data initialization","xC_p","double",
          context__.to_vec(ahead, nt));
      xC_p = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(xC_p, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xC_p_flat__;
        current_statement__ = 124;
        assign(xC_p_flat__, nil_index_list(), context__.vals_r("xC_p"),
          "assigning variable xC_p_flat__");
        current_statement__ = 124;
        pos__ = 1;
        current_statement__ = 124;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 124;
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            current_statement__ = 124;
            assign(xC_p,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xC_p_flat__[(pos__ - 1)], "assigning variable xC_p");
            current_statement__ = 124;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 125;
      validate_non_negative_index("future_rts", "ahead", ahead);
      current_statement__ = 126;
      validate_non_negative_index("future_rts", "nt", nt);
      current_statement__ = 127;
      context__.validate_dims("data initialization","future_rts","double",
          context__.to_vec(ahead, nt));
      future_rts = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(future_rts, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> future_rts_flat__;
        current_statement__ = 127;
        assign(future_rts_flat__, nil_index_list(),
          context__.vals_r("future_rts"),
          "assigning variable future_rts_flat__");
        current_statement__ = 127;
        pos__ = 1;
        current_statement__ = 127;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 127;
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            current_statement__ = 127;
            assign(future_rts,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              future_rts_flat__[(pos__ - 1)], "assigning variable future_rts");
            current_statement__ = 127;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 128;
      context__.validate_dims("data initialization","compute_log_lik","int",
          context__.to_vec());
      compute_log_lik = std::numeric_limits<int>::min();
      
      current_statement__ = 128;
      compute_log_lik = context__.vals_i("compute_log_lik")[(1 - 1)];
      current_statement__ = 128;
      current_statement__ = 128;
      check_greater_or_equal(function__, "compute_log_lik", compute_log_lik,
                             0);
      current_statement__ = 128;
      current_statement__ = 128;
      check_less_or_equal(function__, "compute_log_lik", compute_log_lik, 1);
      current_statement__ = 129;
      validate_non_negative_index("xC_c", "ahead + max(Q, P)",
                                  (ahead + std::max(Q, P)));
      current_statement__ = 130;
      validate_non_negative_index("xC_c", "nt", nt);
      current_statement__ = 131;
      xC_c = Eigen::Matrix<double, -1, -1>((ahead + std::max(Q, P)), nt);
      stan::math::fill(xC_c, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 132;
      validate_non_negative_index("xC_m", "T", T);
      current_statement__ = 133;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 134;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 135;
      xC_m = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(xC_m, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 136;
      xC_marker = std::numeric_limits<int>::min();
      
      current_statement__ = 136;
      xC_marker = 0;
      current_statement__ = 137;
      cp = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 143;
      for (int t = 1; t <= T; ++t) {
        current_statement__ = 138;
        assign(xC_m, cons_list(index_uni(t), nil_index_list()),
          diag_matrix(xC[(t - 1)]), "assigning variable xC_m");
        current_statement__ = 139;
        cp = sum(multiply(transpose(xC_m[(t - 1)]), xC_m[(t - 1)]));
        current_statement__ = 141;
        if (logical_neq(cp, 0)) {
          current_statement__ = 140;
          xC_marker = (xC_marker + 1);
        } }
      current_statement__ = 146;
      for (int i = 1; i <= std::max(Q, P); ++i) {
        current_statement__ = 144;
        assign(xC_c, cons_list(index_uni(i), nil_index_list()),
          transpose(xC[((T - (std::max(Q, P) - 1)) - 1)]),
          "assigning variable xC_c");}
      current_statement__ = 149;
      for (int i = 1; i <= ahead; ++i) {
        current_statement__ = 147;
        assign(xC_c,
          cons_list(index_uni((i + std::max(Q, P))), nil_index_list()),
          transpose(xC_p[(i - 1)]), "assigning variable xC_c");}
      current_statement__ = 136;
      current_statement__ = 136;
      check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
      current_statement__ = 137;
      current_statement__ = 137;
      check_greater_or_equal(function__, "cp", cp, 0);
      current_statement__ = 150;
      validate_non_negative_index("phi0", "nt", nt);
      current_statement__ = 151;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 152;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 153;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 154;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 155;
      validate_non_negative_index("beta", "nt", nt);
      current_statement__ = 156;
      validate_non_negative_index("c_h", "nt", nt);
      current_statement__ = 157;
      validate_non_negative_index("a_h", "Q", Q);
      current_statement__ = 158;
      validate_non_negative_index("a_h", "nt", nt);
      current_statement__ = 159;
      validate_non_negative_index("b_h", "P", P);
      current_statement__ = 160;
      validate_non_negative_index("b_h", "nt", nt);
      current_statement__ = 161;
      validate_non_negative_index("S", "nt", nt);
      current_statement__ = 161;
      validate_non_negative_index("S", "nt", nt);
      current_statement__ = 162;
      validate_non_negative_index("H", "T", T);
      current_statement__ = 163;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 163;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 164;
      validate_non_negative_index("R", "T", T);
      current_statement__ = 165;
      validate_non_negative_index("R", "nt", nt);
      current_statement__ = 165;
      validate_non_negative_index("R", "nt", nt);
      current_statement__ = 166;
      rr_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 166;
      rr_1dim__ = (T - 1);
      current_statement__ = 166;
      validate_non_negative_index("rr", "T - 1", rr_1dim__);
      current_statement__ = 167;
      validate_non_negative_index("rr", "nt", nt);
      current_statement__ = 168;
      validate_non_negative_index("mu", "T", T);
      current_statement__ = 169;
      validate_non_negative_index("mu", "nt", nt);
      current_statement__ = 170;
      validate_non_negative_index("D", "T", T);
      current_statement__ = 171;
      validate_non_negative_index("D", "nt", nt);
      current_statement__ = 172;
      validate_non_negative_index("Qr", "T", T);
      current_statement__ = 173;
      validate_non_negative_index("Qr", "nt", nt);
      current_statement__ = 173;
      validate_non_negative_index("Qr", "nt", nt);
      current_statement__ = 174;
      validate_non_negative_index("Qr_sdi", "T", T);
      current_statement__ = 175;
      validate_non_negative_index("Qr_sdi", "nt", nt);
      current_statement__ = 176;
      validate_non_negative_index("u", "T", T);
      current_statement__ = 177;
      validate_non_negative_index("u", "nt", nt);
      current_statement__ = 178;
      rts_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 178;
      rts_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 178;
      validate_non_negative_index("rts_p", "ahead + max(Q, P)", rts_p_1dim__);
      current_statement__ = 179;
      validate_non_negative_index("rts_p", "nt", nt);
      current_statement__ = 180;
      validate_non_negative_index("rts_forecasted", "ahead", ahead);
      current_statement__ = 181;
      validate_non_negative_index("rts_forecasted", "nt", nt);
      current_statement__ = 182;
      H_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 182;
      H_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 182;
      validate_non_negative_index("H_p", "ahead + max(Q, P)", H_p_1dim__);
      current_statement__ = 183;
      validate_non_negative_index("H_p", "nt", nt);
      current_statement__ = 183;
      validate_non_negative_index("H_p", "nt", nt);
      current_statement__ = 184;
      validate_non_negative_index("H_forecasted", "ahead", ahead);
      current_statement__ = 185;
      validate_non_negative_index("H_forecasted", "nt", nt);
      current_statement__ = 185;
      validate_non_negative_index("H_forecasted", "nt", nt);
      current_statement__ = 186;
      R_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 186;
      R_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 186;
      validate_non_negative_index("R_p", "ahead + max(Q, P)", R_p_1dim__);
      current_statement__ = 187;
      validate_non_negative_index("R_p", "nt", nt);
      current_statement__ = 187;
      validate_non_negative_index("R_p", "nt", nt);
      current_statement__ = 188;
      validate_non_negative_index("R_forecasted", "ahead", ahead);
      current_statement__ = 189;
      validate_non_negative_index("R_forecasted", "nt", nt);
      current_statement__ = 189;
      validate_non_negative_index("R_forecasted", "nt", nt);
      current_statement__ = 190;
      rr_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 190;
      rr_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 190;
      validate_non_negative_index("rr_p", "ahead + max(Q, P)", rr_p_1dim__);
      current_statement__ = 191;
      validate_non_negative_index("rr_p", "nt", nt);
      current_statement__ = 192;
      mu_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 192;
      mu_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 192;
      validate_non_negative_index("mu_p", "ahead + max(Q, P)", mu_p_1dim__);
      current_statement__ = 193;
      validate_non_negative_index("mu_p", "nt", nt);
      current_statement__ = 194;
      validate_non_negative_index("mu_forecasted", "ahead", ahead);
      current_statement__ = 195;
      validate_non_negative_index("mu_forecasted", "nt", nt);
      current_statement__ = 196;
      D_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 196;
      D_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 196;
      validate_non_negative_index("D_p", "ahead + max(Q, P)", D_p_1dim__);
      current_statement__ = 197;
      validate_non_negative_index("D_p", "nt", nt);
      current_statement__ = 198;
      Qr_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 198;
      Qr_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 198;
      validate_non_negative_index("Qr_p", "ahead + max(Q, P)", Qr_p_1dim__);
      current_statement__ = 199;
      validate_non_negative_index("Qr_p", "nt", nt);
      current_statement__ = 199;
      validate_non_negative_index("Qr_p", "nt", nt);
      current_statement__ = 200;
      u_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 200;
      u_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 200;
      validate_non_negative_index("u_p", "ahead + max(Q, P)", u_p_1dim__);
      current_statement__ = 201;
      validate_non_negative_index("u_p", "nt", nt);
      current_statement__ = 202;
      Qr_sdi_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 202;
      Qr_sdi_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 202;
      validate_non_negative_index("Qr_sdi_p", "ahead + max(Q, P)",
                                  Qr_sdi_p_1dim__);
      current_statement__ = 203;
      validate_non_negative_index("Qr_sdi_p", "nt", nt);
      current_statement__ = 204;
      log_lik_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 204;
      log_lik_1dim__ = (logical_eq(compute_log_lik, 1) ? ahead : 0);
      current_statement__ = 204;
      validate_non_negative_index("log_lik",
                                  "compute_log_lik == 1 ? ahead : 0",
                                  log_lik_1dim__);
      current_statement__ = 205;
      validate_non_negative_index("vd_p", "nt", nt);
      current_statement__ = 206;
      validate_non_negative_index("ma_d_p", "nt", nt);
      current_statement__ = 207;
      validate_non_negative_index("ar_d_p", "nt", nt);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt;
      num_params_r__ += 1;
      num_params_r__ += nt;
      num_params_r__ += Q * nt;
      num_params_r__ += P * nt;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += ((nt * (nt - 1)) / 2);
      num_params_r__ += T * (nt + ((nt * (nt - 1)) / 2));
      num_params_r__ += T * ((nt * (nt - 1)) / 2);
      num_params_r__ += rr_1dim__ * nt;
      num_params_r__ += T * nt;
      num_params_r__ += T * nt;
      num_params_r__ += T * (nt + ((nt * (nt - 1)) / 2));
      num_params_r__ += T * nt;
      num_params_r__ += T * nt;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_forecastDCC_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> phi0;
      phi0 = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(phi0, DUMMY_VAR__);
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, -1> phi;
      phi = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(phi, DUMMY_VAR__);
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          if (jacobian__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1, lp__), "assigning variable phi");
          } else {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1), "assigning variable phi");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, -1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(theta, DUMMY_VAR__);
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          if (jacobian__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1, lp__), "assigning variable theta");
          } else {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1), "assigning variable theta");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 4;
      beta = in__.vector(nt);
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 5;
      nu = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        nu = stan::math::lb_constrain(nu, 2, lp__);
      } else {
        current_statement__ = 5;
        nu = stan::math::lb_constrain(nu, 2);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> c_h;
      c_h = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(c_h, DUMMY_VAR__);
      
      current_statement__ = 6;
      c_h = in__.vector(nt);
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> a_h;
      a_h = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(Q, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(a_h, DUMMY_VAR__);
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        assign(a_h, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable a_h");}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 7;
          if (jacobian__) {
            current_statement__ = 7;
            assign(a_h,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(a_h[(sym1__ - 1)][(sym2__ - 1)], 0,
                lp__), "assigning variable a_h");
          } else {
            current_statement__ = 7;
            assign(a_h,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(a_h[(sym1__ - 1)][(sym2__ - 1)], 0),
              "assigning variable a_h");
          }}}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> b_h;
      b_h = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(P, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(b_h, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        assign(b_h, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable b_h");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 8;
          if (jacobian__) {
            current_statement__ = 8;
            assign(b_h,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(b_h[(sym1__ - 1)][(sym2__ - 1)], 0,
                1, lp__), "assigning variable b_h");
          } else {
            current_statement__ = 8;
            assign(b_h,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(b_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
              "assigning variable b_h");
          }}}
      local_scalar_t__ a_q;
      a_q = DUMMY_VAR__;
      
      current_statement__ = 9;
      a_q = in__.scalar();
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        a_q = stan::math::lub_constrain(a_q, 0, 1, lp__);
      } else {
        current_statement__ = 9;
        a_q = stan::math::lub_constrain(a_q, 0, 1);
      }
      local_scalar_t__ b_q;
      b_q = DUMMY_VAR__;
      
      current_statement__ = 10;
      b_q = in__.scalar();
      current_statement__ = 10;
      if (jacobian__) {
        current_statement__ = 10;
        b_q = stan::math::lub_constrain(b_q, 0, (1 - a_q), lp__);
      } else {
        current_statement__ = 10;
        b_q = stan::math::lub_constrain(b_q, 0, (1 - a_q));
      }
      Eigen::Matrix<local_scalar_t__, -1, -1> S;
      S = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(S, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> S_in__;
      S_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(S_in__, DUMMY_VAR__);
      
      current_statement__ = 11;
      S_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 11;
      if (jacobian__) {
        current_statement__ = 11;
        assign(S, nil_index_list(),
          stan::math::corr_matrix_constrain(S_in__, nt, lp__),
          "assigning variable S");
      } else {
        current_statement__ = 11;
        assign(S, nil_index_list(),
          stan::math::corr_matrix_constrain(S_in__, nt),
          "assigning variable S");
      }
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> H;
      H = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(T, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(H, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> H_in__;
      H_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_in__, DUMMY_VAR__);
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 12;
        assign(H_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((nt + ((nt * (nt - 1)) / 2))),
          "assigning variable H_in__");}
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 12;
        if (jacobian__) {
          current_statement__ = 12;
          assign(H, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt, lp__),
            "assigning variable H");
        } else {
          current_statement__ = 12;
          assign(H, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt),
            "assigning variable H");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> R;
      R = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(T, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(R, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> R_in__;
      R_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        ((nt * (nt - 1)) / 2)));
      stan::math::fill(R_in__, DUMMY_VAR__);
      
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        assign(R_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(((nt * (nt - 1)) / 2)), "assigning variable R_in__");}
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        if (jacobian__) {
          current_statement__ = 13;
          assign(R, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::corr_matrix_constrain(R_in__[(sym1__ - 1)], nt, lp__),
            "assigning variable R");
        } else {
          current_statement__ = 13;
          assign(R, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::corr_matrix_constrain(R_in__[(sym1__ - 1)], nt),
            "assigning variable R");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> rr;
      rr = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(rr_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(rr, DUMMY_VAR__);
      
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        current_statement__ = 14;
        assign(rr, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable rr");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 15;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 15;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable mu");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> D;
      D = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(D, DUMMY_VAR__);
      
      current_statement__ = 16;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 16;
        assign(D, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable D");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> Qr;
      Qr = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(T, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(Qr, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> Qr_in__;
      Qr_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(Qr_in__, DUMMY_VAR__);
      
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 17;
        assign(Qr_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((nt + ((nt * (nt - 1)) / 2))),
          "assigning variable Qr_in__");}
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 17;
        if (jacobian__) {
          current_statement__ = 17;
          assign(Qr, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(Qr_in__[(sym1__ - 1)], nt, lp__),
            "assigning variable Qr");
        } else {
          current_statement__ = 17;
          assign(Qr, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(Qr_in__[(sym1__ - 1)], nt),
            "assigning variable Qr");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> Qr_sdi;
      Qr_sdi = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(Qr_sdi, DUMMY_VAR__);
      
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 18;
        assign(Qr_sdi, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable Qr_sdi");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> u;
      u = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(u, DUMMY_VAR__);
      
      current_statement__ = 19;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 19;
        assign(u, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable u");}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_forecastDCC_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta");}}
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      beta = in__.vector(nt);
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      nu = in__.scalar();
      current_statement__ = 5;
      nu = stan::math::lb_constrain(nu, 2);
      Eigen::Matrix<double, -1, 1> c_h;
      c_h = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(c_h, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      c_h = in__.vector(nt);
      std::vector<Eigen::Matrix<double, -1, 1>> a_h;
      a_h = std::vector<Eigen::Matrix<double, -1, 1>>(Q, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(a_h, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        assign(a_h, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable a_h");}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 7;
          assign(a_h,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_constrain(a_h[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable a_h");}}
      std::vector<Eigen::Matrix<double, -1, 1>> b_h;
      b_h = std::vector<Eigen::Matrix<double, -1, 1>>(P, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(b_h, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        assign(b_h, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable b_h");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 8;
          assign(b_h,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(b_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
            "assigning variable b_h");}}
      double a_q;
      a_q = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      a_q = in__.scalar();
      current_statement__ = 9;
      a_q = stan::math::lub_constrain(a_q, 0, 1);
      double b_q;
      b_q = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      b_q = in__.scalar();
      current_statement__ = 10;
      b_q = stan::math::lub_constrain(b_q, 0, (1 - a_q));
      Eigen::Matrix<double, -1, -1> S;
      S = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(S, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> S_in__;
      S_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(S_in__, DUMMY_VAR__);
      
      current_statement__ = 11;
      S_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 11;
      assign(S, nil_index_list(),
        stan::math::corr_matrix_constrain(S_in__, nt), "assigning variable S");
      std::vector<Eigen::Matrix<double, -1, -1>> H;
      H = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> H_in__;
      H_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_in__, DUMMY_VAR__);
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 12;
        assign(H_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((nt + ((nt * (nt - 1)) / 2))),
          "assigning variable H_in__");}
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 12;
        assign(H, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt),
          "assigning variable H");}
      std::vector<Eigen::Matrix<double, -1, -1>> R;
      R = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(R, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> R_in__;
      R_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        ((nt * (nt - 1)) / 2)));
      stan::math::fill(R_in__, DUMMY_VAR__);
      
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        assign(R_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(((nt * (nt - 1)) / 2)), "assigning variable R_in__");}
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        assign(R, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::corr_matrix_constrain(R_in__[(sym1__ - 1)], nt),
          "assigning variable R");}
      std::vector<Eigen::Matrix<double, -1, 1>> rr;
      rr = std::vector<Eigen::Matrix<double, -1, 1>>(rr_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rr, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        current_statement__ = 14;
        assign(rr, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable rr");}
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 15;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 15;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable mu");}
      std::vector<Eigen::Matrix<double, -1, 1>> D;
      D = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(D, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 16;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 16;
        assign(D, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable D");}
      std::vector<Eigen::Matrix<double, -1, -1>> Qr;
      Qr = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(Qr, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> Qr_in__;
      Qr_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(Qr_in__, DUMMY_VAR__);
      
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 17;
        assign(Qr_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((nt + ((nt * (nt - 1)) / 2))),
          "assigning variable Qr_in__");}
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 17;
        assign(Qr, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_constrain(Qr_in__[(sym1__ - 1)], nt),
          "assigning variable Qr");}
      std::vector<Eigen::Matrix<double, -1, 1>> Qr_sdi;
      Qr_sdi = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(Qr_sdi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 18;
        assign(Qr_sdi, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable Qr_sdi");}
      std::vector<Eigen::Matrix<double, -1, 1>> u;
      u = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(u, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 19;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 19;
        assign(u, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable u");}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "phi"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "theta"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(nu);
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(c_h[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
          vars__.emplace_back(a_h[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          vars__.emplace_back(b_h[(sym2__ - 1)][(sym1__ - 1)]);}}
      vars__.emplace_back(a_q);
      vars__.emplace_back(b_q);
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(S,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "S"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
            vars__.emplace_back(
              rvalue(H,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "H"));}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
            vars__.emplace_back(
              rvalue(R,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "R"));}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
          vars__.emplace_back(rr[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(mu[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(D[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
            vars__.emplace_back(
              rvalue(Qr,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "Qr"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(Qr_sdi[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(u[(sym2__ - 1)][(sym1__ - 1)]);}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<Eigen::Matrix<double, -1, 1>> rts_p;
      rts_p = std::vector<Eigen::Matrix<double, -1, 1>>(rts_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> rts_forecasted;
      rts_forecasted = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> H_p;
      H_p = std::vector<Eigen::Matrix<double, -1, -1>>(H_p_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> H_forecasted;
      H_forecasted = std::vector<Eigen::Matrix<double, -1, -1>>(ahead, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> R_p;
      R_p = std::vector<Eigen::Matrix<double, -1, -1>>(R_p_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(R_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> R_forecasted;
      R_forecasted = std::vector<Eigen::Matrix<double, -1, -1>>(ahead, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(R_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> rr_p;
      rr_p = std::vector<Eigen::Matrix<double, -1, 1>>(rr_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rr_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> mu_p;
      mu_p = std::vector<Eigen::Matrix<double, -1, 1>>(mu_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> mu_forecasted;
      mu_forecasted = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> D_p;
      D_p = std::vector<Eigen::Matrix<double, -1, 1>>(D_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(D_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> Qr_p;
      Qr_p = std::vector<Eigen::Matrix<double, -1, -1>>(Qr_p_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(Qr_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> u_p;
      u_p = std::vector<Eigen::Matrix<double, -1, 1>>(u_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(u_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> Qr_sdi_p;
      Qr_sdi_p = std::vector<Eigen::Matrix<double, -1, 1>>(Qr_sdi_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(Qr_sdi_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> log_lik;
      log_lik = std::vector<double>(log_lik_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> vd_p;
      vd_p = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> ma_d_p;
      ma_d_p = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> ar_d_p;
      ar_d_p = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 37;
      assign(rts_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rts,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "rts"),
        "assigning variable rts_p");
      current_statement__ = 38;
      assign(H_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(H,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "H"),
        "assigning variable H_p");
      current_statement__ = 39;
      assign(mu_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(mu,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "mu"),
        "assigning variable mu_p");
      current_statement__ = 40;
      assign(rr_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rr,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "rr"),
        "assigning variable rr_p");
      current_statement__ = 41;
      assign(D_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(D,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "D"),
        "assigning variable D_p");
      current_statement__ = 42;
      assign(u_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(u,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "u"),
        "assigning variable u_p");
      current_statement__ = 43;
      assign(Qr_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(Qr,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "Qr"),
        "assigning variable Qr_p");
      current_statement__ = 44;
      assign(Qr_sdi_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(Qr_sdi,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "Qr_sdi"),
        "assigning variable Qr_sdi_p");
      current_statement__ = 45;
      assign(R_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(R,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "R"),
        "assigning variable R_p");
      current_statement__ = 46;
      assign(rts_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rts,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "rts"),
        "assigning variable rts_p");
      current_statement__ = 47;
      assign(H_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(H,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "H"),
        "assigning variable H_p");
      current_statement__ = 48;
      assign(mu_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(mu,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "mu"),
        "assigning variable mu_p");
      current_statement__ = 49;
      assign(rr_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rr,
          cons_list(index_min_max(((T - 1) - (std::max(Q, P) - 1)), (T - 1)),
            cons_list(index_omni(), nil_index_list())), "rr"),
        "assigning variable rr_p");
      current_statement__ = 50;
      assign(D_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(D,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "D"),
        "assigning variable D_p");
      current_statement__ = 51;
      assign(u_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(u,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "u"),
        "assigning variable u_p");
      current_statement__ = 52;
      assign(Qr_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(Qr,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "Qr"),
        "assigning variable Qr_p");
      current_statement__ = 53;
      assign(Qr_sdi_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(Qr_sdi,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "Qr_sdi"),
        "assigning variable Qr_sdi_p");
      current_statement__ = 54;
      assign(R_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(R,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "R"),
        "assigning variable R_p");
      current_statement__ = 92;
      for (int t = (std::max(Q, P) + 1); t <= (std::max(Q, P) + ahead); ++t) {
        current_statement__ = 60;
        if (logical_eq(meanstructure, 0)) {
          current_statement__ = 58;
          assign(mu_p,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())), phi0,
            "assigning variable mu_p");
        } else {
          current_statement__ = 57;
          if (logical_eq(meanstructure, 1)) {
            current_statement__ = 55;
            assign(mu_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(
                add(phi0,
                  multiply(phi,
                    rvalue(rts_p,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts_p"))),
                multiply(theta,
                  subtract(
                    rvalue(rts_p,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts_p"),
                    stan::model::deep_copy(
                      rvalue(mu_p,
                        cons_list(index_uni((t - 1)),
                          cons_list(index_omni(), nil_index_list())), "mu_p"))))),
              "assigning variable mu_p");
          } 
        }
        current_statement__ = 79;
        for (int d = 1; d <= nt; ++d) {
          current_statement__ = 61;
          assign(vd_p, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable vd_p");
          current_statement__ = 62;
          assign(ma_d_p, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable ma_d_p");
          current_statement__ = 63;
          assign(ar_d_p, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable ar_d_p");
          current_statement__ = 67;
          for (int q = 1; q <= std::min((t - 1), Q); ++q) {
            current_statement__ = 64;
            assign(rr_p,
              cons_list(index_uni((t - q)),
                cons_list(index_uni(d), nil_index_list())),
              square(
                (rts_p[((t - q) - 1)][(d - 1)] -
                  mu_p[((t - q) - 1)][(d - 1)])), "assigning variable rr_p");
            current_statement__ = 65;
            assign(ma_d_p, cons_list(index_uni(d), nil_index_list()),
              (ma_d_p[(d - 1)] +
                (a_h[(q - 1)][(d - 1)] * rr_p[((t - q) - 1)][(d - 1)])),
              "assigning variable ma_d_p");}
          current_statement__ = 70;
          for (int p = 1; p <= std::min((t - 1), P); ++p) {
            current_statement__ = 68;
            assign(ar_d_p, cons_list(index_uni(d), nil_index_list()),
              (ar_d_p[(d - 1)] +
                (b_h[(p - 1)][(d - 1)] * pow(D_p[((t - p) - 1)][(d - 1)], 2))),
              "assigning variable ar_d_p");}
          current_statement__ = 76;
          if (logical_gte(xC_marker, 1)) {
            current_statement__ = 74;
            assign(vd_p, cons_list(index_uni(d), nil_index_list()),
              ((stan::math::exp(
                  (c_h[(d - 1)] +
                    (beta[(d - 1)] *
                      rvalue(xC_c,
                        cons_list(index_uni(t),
                          cons_list(index_uni(d), nil_index_list())), "xC_c"))))
                 + ma_d_p[(d - 1)]) + ar_d_p[(d - 1)]),
              "assigning variable vd_p");
          } else {
            current_statement__ = 73;
            if (logical_eq(xC_marker, 0)) {
              current_statement__ = 71;
              assign(vd_p, cons_list(index_uni(d), nil_index_list()),
                ((stan::math::exp(c_h[(d - 1)]) + ma_d_p[(d - 1)]) +
                  ar_d_p[(d - 1)]), "assigning variable vd_p");
            } 
          }
          current_statement__ = 77;
          assign(D_p,
            cons_list(index_uni(t),
              cons_list(index_uni(d), nil_index_list())),
            stan::math::sqrt(vd_p[(d - 1)]), "assigning variable D_p");}
        current_statement__ = 80;
        assign(u_p,
          cons_list(index_uni((t - 1)),
            cons_list(index_omni(), nil_index_list())),
          mdivide_left(
            diag_matrix(
              rvalue(D_p,
                cons_list(index_uni((t - 1)),
                  cons_list(index_omni(), nil_index_list())), "D_p")),
            subtract(
              rvalue(rts_p,
                cons_list(index_uni((t - 1)),
                  cons_list(index_omni(), nil_index_list())), "rts_p"),
              rvalue(mu_p,
                cons_list(index_uni((t - 1)),
                  cons_list(index_omni(), nil_index_list())), "mu_p"))),
          "assigning variable u_p");
        current_statement__ = 81;
        assign(Qr_p,
          cons_list(index_uni(t), cons_list(index_omni(), nil_index_list())),
          add(
            add(multiply(((1 - a_q) - b_q), S),
              multiply(a_q,
                multiply(
                  rvalue(u_p,
                    cons_list(index_uni((t - 1)),
                      cons_list(index_omni(), nil_index_list())), "u_p"),
                  transpose(
                    rvalue(u_p,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "u_p"))))),
            multiply(b_q,
              stan::model::deep_copy(
                rvalue(Qr_p,
                  cons_list(index_uni((t - 1)),
                    cons_list(index_omni(), nil_index_list())), "Qr_p")))),
          "assigning variable Qr_p");
        current_statement__ = 82;
        assign(Qr_sdi_p,
          cons_list(index_uni(t), cons_list(index_omni(), nil_index_list())),
          elt_divide(1,
            stan::math::sqrt(
              diagonal(
                rvalue(Qr_p,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "Qr_p")))),
          "assigning variable Qr_sdi_p");
        current_statement__ = 83;
        assign(R_p,
          cons_list(index_uni(t), cons_list(index_omni(), nil_index_list())),
          quad_form_diag(
            rvalue(Qr_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())), "Qr_p"),
            rvalue(Qr_sdi_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())), "Qr_sdi_p")),
          "assigning variable R_p");
        current_statement__ = 84;
        assign(H_p,
          cons_list(index_uni(t), cons_list(index_omni(), nil_index_list())),
          multiply(
            multiply(
              diag_matrix(
                rvalue(D_p,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "D_p")),
              rvalue(R_p,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "R_p")),
            diag_matrix(
              rvalue(D_p,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "D_p"))),
          "assigning variable H_p");
        current_statement__ = 90;
        if (logical_eq(distribution, 0)) {
          current_statement__ = 88;
          assign(rts_p,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())),
            multi_normal_rng(
              rvalue(mu_p,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "mu_p"),
              rvalue(H_p,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H_p"),
              base_rng__), "assigning variable rts_p");
        } else {
          current_statement__ = 87;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 85;
            assign(rts_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              multi_student_t_rng(nu,
                rvalue(mu_p,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu_p"),
                rvalue(H_p,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H_p"),
                base_rng__), "assigning variable rts_p");
          } 
        }}
      current_statement__ = 93;
      assign(rts_forecasted, nil_index_list(),
        rvalue(rts_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "rts_p"), "assigning variable rts_forecasted");
      current_statement__ = 94;
      assign(H_forecasted, nil_index_list(),
        rvalue(H_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "H_p"), "assigning variable H_forecasted");
      current_statement__ = 95;
      assign(R_forecasted, nil_index_list(),
        rvalue(R_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "R_p"), "assigning variable R_forecasted");
      current_statement__ = 96;
      assign(mu_forecasted, nil_index_list(),
        rvalue(mu_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "mu_p"), "assigning variable mu_forecasted");
      current_statement__ = 108;
      if (compute_log_lik) {
        current_statement__ = 106;
        if (logical_eq(distribution, 0)) {
          current_statement__ = 104;
          for (int i = 1; i <= ahead; ++i) {
            current_statement__ = 102;
            assign(log_lik, cons_list(index_uni(i), nil_index_list()),
              multi_normal_lpdf<false>(future_rts[(i - 1)],
                mu_forecasted[(i - 1)], H_forecasted[(i - 1)]),
              "assigning variable log_lik");}
        } else {
          current_statement__ = 101;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 99;
            for (int i = 1; i <= ahead; ++i) {
              current_statement__ = 97;
              assign(log_lik, cons_list(index_uni(i), nil_index_list()),
                multi_student_t_lpdf<false>(future_rts[(i - 1)], nu,
                  mu_forecasted[(i - 1)], H_forecasted[(i - 1)]),
                "assigning variable log_lik");}
          } 
        }
      } 
      current_statement__ = 22;
      for (int sym1__ = 1; sym1__ <= H_p_1dim__; ++sym1__) {
        current_statement__ = 22;
        current_statement__ = 22;
        check_cov_matrix(function__, "H_p[sym1__]", H_p[(sym1__ - 1)]);}
      current_statement__ = 23;
      for (int sym1__ = 1; sym1__ <= ahead; ++sym1__) {
        current_statement__ = 23;
        current_statement__ = 23;
        check_cov_matrix(function__, "H_forecasted[sym1__]",
                         H_forecasted[(sym1__ - 1)]);}
      current_statement__ = 24;
      for (int sym1__ = 1; sym1__ <= R_p_1dim__; ++sym1__) {
        current_statement__ = 24;
        current_statement__ = 24;
        check_corr_matrix(function__, "R_p[sym1__]", R_p[(sym1__ - 1)]);}
      current_statement__ = 25;
      for (int sym1__ = 1; sym1__ <= ahead; ++sym1__) {
        current_statement__ = 25;
        current_statement__ = 25;
        check_corr_matrix(function__, "R_forecasted[sym1__]",
                          R_forecasted[(sym1__ - 1)]);}
      current_statement__ = 30;
      for (int sym1__ = 1; sym1__ <= Qr_p_1dim__; ++sym1__) {
        current_statement__ = 30;
        current_statement__ = 30;
        check_cov_matrix(function__, "Qr_p[sym1__]", Qr_p[(sym1__ - 1)]);}
      current_statement__ = 34;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 34;
        current_statement__ = 34;
        check_greater_or_equal(function__, "vd_p[sym1__]",
                               vd_p[(sym1__ - 1)], 0);}
      current_statement__ = 35;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 35;
        current_statement__ = 35;
        check_greater_or_equal(function__, "ma_d_p[sym1__]",
                               ma_d_p[(sym1__ - 1)], 0);}
      current_statement__ = 36;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 36;
        current_statement__ = 36;
        check_greater_or_equal(function__, "ar_d_p[sym1__]",
                               ar_d_p[(sym1__ - 1)], 0);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
          vars__.emplace_back(rts_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
          vars__.emplace_back(rts_forecasted[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= H_p_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(H_p,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "H_p"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
            vars__.emplace_back(
              rvalue(H_forecasted,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "H_forecasted"));}}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= R_p_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(R_p,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "R_p"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
            vars__.emplace_back(
              rvalue(R_forecasted,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "R_forecasted"));}}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= rr_p_1dim__; ++sym2__) {
          vars__.emplace_back(rr_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
          vars__.emplace_back(mu_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
          vars__.emplace_back(mu_forecasted[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= D_p_1dim__; ++sym2__) {
          vars__.emplace_back(D_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= Qr_p_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(Qr_p,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "Qr_p"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= u_p_1dim__; ++sym2__) {
          vars__.emplace_back(u_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= Qr_sdi_p_1dim__; ++sym2__) {
          vars__.emplace_back(Qr_sdi_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(vd_p[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(ma_d_p[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(ar_d_p[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi0_flat__;
        current_statement__ = 1;
        assign(phi0_flat__, nil_index_list(), context__.vals_r("phi0"),
          "assigning variable phi0_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 1;
          assign(phi0, cons_list(index_uni(sym1__), nil_index_list()),
            phi0_flat__[(pos__ - 1)], "assigning variable phi0");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi_flat__;
        current_statement__ = 2;
        assign(phi_flat__, nil_index_list(), context__.vals_r("phi"),
          "assigning variable phi_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              phi_flat__[(pos__ - 1)], "assigning variable phi");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> phi_free__;
      phi_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi_free__");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_flat__;
        current_statement__ = 3;
        assign(theta_flat__, nil_index_list(), context__.vals_r("theta"),
          "assigning variable theta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              theta_flat__[(pos__ - 1)], "assigning variable theta");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> theta_free__;
      theta_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta_free__");}}
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 4;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 4;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      nu_free__ = stan::math::lb_free(nu, 2);
      Eigen::Matrix<double, -1, 1> c_h;
      c_h = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(c_h, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> c_h_flat__;
        current_statement__ = 6;
        assign(c_h_flat__, nil_index_list(), context__.vals_r("c_h"),
          "assigning variable c_h_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 6;
          assign(c_h, cons_list(index_uni(sym1__), nil_index_list()),
            c_h_flat__[(pos__ - 1)], "assigning variable c_h");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> a_h;
      a_h = std::vector<Eigen::Matrix<double, -1, 1>>(Q, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(a_h, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a_h_flat__;
        current_statement__ = 7;
        assign(a_h_flat__, nil_index_list(), context__.vals_r("a_h"),
          "assigning variable a_h_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 7;
          for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
            current_statement__ = 7;
            assign(a_h,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              a_h_flat__[(pos__ - 1)], "assigning variable a_h");
            current_statement__ = 7;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> a_h_free__;
      a_h_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(Q, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(a_h_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 7;
          assign(a_h_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_free(a_h[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable a_h_free__");}}
      std::vector<Eigen::Matrix<double, -1, 1>> b_h;
      b_h = std::vector<Eigen::Matrix<double, -1, 1>>(P, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(b_h, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> b_h_flat__;
        current_statement__ = 8;
        assign(b_h_flat__, nil_index_list(), context__.vals_r("b_h"),
          "assigning variable b_h_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 8;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 8;
            assign(b_h,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              b_h_flat__[(pos__ - 1)], "assigning variable b_h");
            current_statement__ = 8;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> b_h_free__;
      b_h_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(P, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(b_h_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 8;
          assign(b_h_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(b_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
            "assigning variable b_h_free__");}}
      double a_q;
      a_q = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      a_q = context__.vals_r("a_q")[(1 - 1)];
      double a_q_free__;
      a_q_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      a_q_free__ = stan::math::lub_free(a_q, 0, 1);
      double b_q;
      b_q = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      b_q = context__.vals_r("b_q")[(1 - 1)];
      double b_q_free__;
      b_q_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      b_q_free__ = stan::math::lub_free(b_q, 0, (1 - a_q));
      Eigen::Matrix<double, -1, -1> S;
      S = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(S, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> S_flat__;
        current_statement__ = 11;
        assign(S_flat__, nil_index_list(), context__.vals_r("S"),
          "assigning variable S_flat__");
        current_statement__ = 11;
        pos__ = 1;
        current_statement__ = 11;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 11;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 11;
            assign(S,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              S_flat__[(pos__ - 1)], "assigning variable S");
            current_statement__ = 11;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> S_free__;
      S_free__ = Eigen::Matrix<double, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(S_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      assign(S_free__, nil_index_list(), stan::math::corr_matrix_free(S),
        "assigning variable S_free__");
      std::vector<Eigen::Matrix<double, -1, -1>> H;
      H = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> H_flat__;
        current_statement__ = 12;
        assign(H_flat__, nil_index_list(), context__.vals_r("H"),
          "assigning variable H_flat__");
        current_statement__ = 12;
        pos__ = 1;
        current_statement__ = 12;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 12;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 12;
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              current_statement__ = 12;
              assign(H,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                H_flat__[(pos__ - 1)], "assigning variable H");
              current_statement__ = 12;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> H_free__;
      H_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 12;
        assign(H_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_free(H[(sym1__ - 1)]),
          "assigning variable H_free__");}
      std::vector<Eigen::Matrix<double, -1, -1>> R;
      R = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(R, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> R_flat__;
        current_statement__ = 13;
        assign(R_flat__, nil_index_list(), context__.vals_r("R"),
          "assigning variable R_flat__");
        current_statement__ = 13;
        pos__ = 1;
        current_statement__ = 13;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 13;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 13;
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              current_statement__ = 13;
              assign(R,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                R_flat__[(pos__ - 1)], "assigning variable R");
              current_statement__ = 13;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> R_free__;
      R_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(
        ((nt * (nt - 1)) / 2)));
      stan::math::fill(R_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        assign(R_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::corr_matrix_free(R[(sym1__ - 1)]),
          "assigning variable R_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> rr;
      rr = std::vector<Eigen::Matrix<double, -1, 1>>(rr_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rr, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rr_flat__;
        current_statement__ = 14;
        assign(rr_flat__, nil_index_list(), context__.vals_r("rr"),
          "assigning variable rr_flat__");
        current_statement__ = 14;
        pos__ = 1;
        current_statement__ = 14;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 14;
          for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
            current_statement__ = 14;
            assign(rr,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rr_flat__[(pos__ - 1)], "assigning variable rr");
            current_statement__ = 14;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 15;
        assign(mu_flat__, nil_index_list(), context__.vals_r("mu"),
          "assigning variable mu_flat__");
        current_statement__ = 15;
        pos__ = 1;
        current_statement__ = 15;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 15;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 15;
            assign(mu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              mu_flat__[(pos__ - 1)], "assigning variable mu");
            current_statement__ = 15;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> D;
      D = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(D, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> D_flat__;
        current_statement__ = 16;
        assign(D_flat__, nil_index_list(), context__.vals_r("D"),
          "assigning variable D_flat__");
        current_statement__ = 16;
        pos__ = 1;
        current_statement__ = 16;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 16;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 16;
            assign(D,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              D_flat__[(pos__ - 1)], "assigning variable D");
            current_statement__ = 16;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, -1>> Qr;
      Qr = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(Qr, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Qr_flat__;
        current_statement__ = 17;
        assign(Qr_flat__, nil_index_list(), context__.vals_r("Qr"),
          "assigning variable Qr_flat__");
        current_statement__ = 17;
        pos__ = 1;
        current_statement__ = 17;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 17;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 17;
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              current_statement__ = 17;
              assign(Qr,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                Qr_flat__[(pos__ - 1)], "assigning variable Qr");
              current_statement__ = 17;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> Qr_free__;
      Qr_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(Qr_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 17;
        assign(Qr_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_free(Qr[(sym1__ - 1)]),
          "assigning variable Qr_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> Qr_sdi;
      Qr_sdi = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(Qr_sdi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Qr_sdi_flat__;
        current_statement__ = 18;
        assign(Qr_sdi_flat__, nil_index_list(), context__.vals_r("Qr_sdi"),
          "assigning variable Qr_sdi_flat__");
        current_statement__ = 18;
        pos__ = 1;
        current_statement__ = 18;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 18;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 18;
            assign(Qr_sdi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Qr_sdi_flat__[(pos__ - 1)], "assigning variable Qr_sdi");
            current_statement__ = 18;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> u;
      u = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(u, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> u_flat__;
        current_statement__ = 19;
        assign(u_flat__, nil_index_list(), context__.vals_r("u"),
          "assigning variable u_flat__");
        current_statement__ = 19;
        pos__ = 1;
        current_statement__ = 19;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 19;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 19;
            assign(u,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              u_flat__[(pos__ - 1)], "assigning variable u");
            current_statement__ = 19;
            pos__ = (pos__ + 1);}}
      }
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "phi_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "theta_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(nu_free__);
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(c_h[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(a_h_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(b_h_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      vars__.emplace_back(a_q_free__);
      vars__.emplace_back(b_q_free__);
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        vars__.emplace_back(S_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym2__) {
          vars__.emplace_back(H_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ((nt * (nt - 1)) / 2); ++sym2__) {
          vars__.emplace_back(R_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(rr[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(mu[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(D[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym2__) {
          vars__.emplace_back(Qr_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(Qr_sdi[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(u[(sym1__ - 1)][(sym2__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("phi0");
    names__.emplace_back("phi");
    names__.emplace_back("theta");
    names__.emplace_back("beta");
    names__.emplace_back("nu");
    names__.emplace_back("c_h");
    names__.emplace_back("a_h");
    names__.emplace_back("b_h");
    names__.emplace_back("a_q");
    names__.emplace_back("b_q");
    names__.emplace_back("S");
    names__.emplace_back("H");
    names__.emplace_back("R");
    names__.emplace_back("rr");
    names__.emplace_back("mu");
    names__.emplace_back("D");
    names__.emplace_back("Qr");
    names__.emplace_back("Qr_sdi");
    names__.emplace_back("u");
    names__.emplace_back("rts_p");
    names__.emplace_back("rts_forecasted");
    names__.emplace_back("H_p");
    names__.emplace_back("H_forecasted");
    names__.emplace_back("R_p");
    names__.emplace_back("R_forecasted");
    names__.emplace_back("rr_p");
    names__.emplace_back("mu_p");
    names__.emplace_back("mu_forecasted");
    names__.emplace_back("D_p");
    names__.emplace_back("Qr_p");
    names__.emplace_back("u_p");
    names__.emplace_back("Qr_sdi_p");
    names__.emplace_back("log_lik");
    names__.emplace_back("vd_p");
    names__.emplace_back("ma_d_p");
    names__.emplace_back("ar_d_p");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Q),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rr_1dim__),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(rts_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(H_p_1dim__),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(R_p_1dim__),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rr_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(D_p_1dim__),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Qr_p_1dim__)
                                             , static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(u_p_1dim__),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(Qr_sdi_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(log_lik_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "nu");
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "c_h" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "a_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "b_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    param_names__.emplace_back(std::string() + "a_q");
    param_names__.emplace_back(std::string() + "b_q");
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "S" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "R" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "Qr" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "Qr_sdi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "u" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= H_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "H_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "H_forecasted" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= R_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "R_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "R_forecasted" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rr_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rr_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= D_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "D_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= Qr_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "Qr_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= u_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "u_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= Qr_sdi_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Qr_sdi_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "vd_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ma_d_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ar_d_p" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "nu");
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "c_h" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "a_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "b_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    param_names__.emplace_back(std::string() + "a_q");
    param_names__.emplace_back(std::string() + "b_q");
    for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "S" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "R" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "Qr" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "Qr_sdi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "u" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= H_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "H_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "H_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= R_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "R_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "R_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rr_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rr_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= D_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "D_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= Qr_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Qr_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= u_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "u_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= Qr_sdi_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Qr_sdi_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "vd_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ma_d_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ar_d_p" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"c_h\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"a_h\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"b_h\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"a_q\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"b_q\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"S\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"R\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"D\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"Qr\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"Qr_sdi\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"u\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"rts_p\",\"type\":{\"name\":\"array\",\"length\":" << rts_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_p\",\"type\":{\"name\":\"array\",\"length\":" << H_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_p\",\"type\":{\"name\":\"array\",\"length\":" << R_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rr_p\",\"type\":{\"name\":\"array\",\"length\":" << rr_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_p\",\"type\":{\"name\":\"array\",\"length\":" << mu_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"D_p\",\"type\":{\"name\":\"array\",\"length\":" << D_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"Qr_p\",\"type\":{\"name\":\"array\",\"length\":" << Qr_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"u_p\",\"type\":{\"name\":\"array\",\"length\":" << u_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"Qr_sdi_p\",\"type\":{\"name\":\"array\",\"length\":" << Qr_sdi_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << log_lik_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"vd_p\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ma_d_p\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ar_d_p\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"c_h\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"a_h\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"b_h\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"a_q\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"b_q\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"S\",\"type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"parameters\"},{\"name\":\"R\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"D\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"Qr\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"parameters\"},{\"name\":\"Qr_sdi\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"u\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"rts_p\",\"type\":{\"name\":\"array\",\"length\":" << rts_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_p\",\"type\":{\"name\":\"array\",\"length\":" << H_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_p\",\"type\":{\"name\":\"array\",\"length\":" << R_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"generated_quantities\"},{\"name\":\"rr_p\",\"type\":{\"name\":\"array\",\"length\":" << rr_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_p\",\"type\":{\"name\":\"array\",\"length\":" << mu_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"D_p\",\"type\":{\"name\":\"array\",\"length\":" << D_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"Qr_p\",\"type\":{\"name\":\"array\",\"length\":" << Qr_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"generated_quantities\"},{\"name\":\"u_p\",\"type\":{\"name\":\"array\",\"length\":" << u_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"Qr_sdi_p\",\"type\":{\"name\":\"array\",\"length\":" << Qr_sdi_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << log_lik_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"vd_p\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ma_d_p\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ar_d_p\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_forecastDCC_namespace::model_forecastDCC;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_forecastDCC_namespace::profiles__;
}
#endif
#endif
