% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getENSEMBL.Seq.R
\name{getENSEMBL.Seq}
\alias{getENSEMBL.Seq}
\title{Helper function for retrieving biological sequence files from ENSEMBL}
\usage{
getENSEMBL.Seq(
  organism,
  type = "dna",
  id.type = "toplevel",
  release = NULL,
  path
)
}
\arguments{
\item{organism}{scientific name of the organism of interest.}

\item{type}{biological sequence type.}

\item{id.type}{a character, default "toplevel". id type of assembly, either toplevel or primary_assembly usually.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}

\item{path}{location where file shall be stored.}
}
\value{
either a character path to downloaded file, or a logical FALSE, specifying failure.
}
\description{
This function downloads gff files of query
organisms from ENSEMBL.
}
\author{
Hajk-Georg Drost
}
