% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_bioc_readme_rmd.R
\name{use_bioc_readme_rmd}
\alias{use_bioc_readme_rmd}
\title{Create a biocthis-style README.Rmd file}
\usage{
use_bioc_readme_rmd(open = rlang::is_interactive())
}
\arguments{
\item{open}{Open the newly created file for editing? Happens in RStudio,
if applicable, or via \code{utils::file.edit()} otherwise. This argument has the
same behavior as the \code{open} argument used in \code{usethis} functions.}
}
\value{
This function adds and/or replaces the \code{README.Rmd} file in your
R package. It's useful to use \code{devtools::build_readme()} after running
this function or whenever you update the \code{README.Rmd} file.
}
\description{
This function is very similar to \code{usethis::use_readme_rmd()} except that it
uses a template from \code{biocthis}. This template README.Rmd includes
information on how to install your Bioconductor package, how to cite it,
and thanks the authors of several packages. It was built on top of the
original template from \code{usethis::use_readme_rmd()}.
}
\examples{
\dontrun{
## Run this function in your package
use_bioc_readme_rmd()
}

## Create an example package for illustrative purposes.
## Note: you do not need to run this for your own package!
pkgdir <- biocthis_example_pkg(use_git = TRUE)

## Create a template README.Rmd file that is Bioconductor-friendly
biocthis::use_bioc_readme_rmd()
}
