% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_bioc_news_md.R
\name{use_bioc_news_md}
\alias{use_bioc_news_md}
\title{Create a biocthis-style NEWS.md file}
\usage{
use_bioc_news_md(open = rlang::is_interactive())
}
\arguments{
\item{open}{Open the newly created file for editing? Happens in RStudio,
if applicable, or via \code{utils::file.edit()} otherwise. This argument has the
same behavior as the \code{open} argument used in \code{usethis} functions.}
}
\value{
This function adds and/or replaces the \code{NEWS.md} file in your
R package.
}
\description{
This function is very similar to \code{usethis::use_news_md()} except that it
uses a template from \code{biocthis}.
}
\details{
Unlike the original function, \code{use_bioc_news_md()} does not make git commits.
So you won't lose work you didn't save when using this function.
}
\examples{
\dontrun{
## Run this function in your package
use_bioc_news_md()
}

## Create an example package for illustrative purposes.
## Note: you do not need to run this for your own package!
pkgdir <- biocthis_example_pkg()

## Create a template NEWS.md file that is Bioconductor-friendly
biocthis::use_bioc_news_md()
}
