% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_tidiers.R
\name{tidy.deSet}
\alias{tidy.deSet}
\alias{augment.deSet}
\alias{glance.deSet}
\title{Tidying methods for edge's deSet object}
\usage{
\method{tidy}{deSet}(x, addPheno = FALSE, ...)

\method{augment}{deSet}(x, data, ...)

\method{glance}{deSet}(x, ...)
}
\arguments{
\item{x}{deSet object}

\item{addPheno}{whether columns should be included in the tidied output
for those in the ExpressionSet's phenoData}

\item{...}{extra arguments (not used)}

\item{data}{Original data can be added. Default is NULL.}
}
\value{
\code{tidy} returns a data frame with one row per gene-sample
combination, with columns
  \item{gene}{gene name}
  \item{sample}{sample name (from column names)}
  \item{value}{expressions on log2 scale}

\code{augment} returns a data.frame with
    \item{p.value}{the original p-values given to \code{qvalue}}
    \item{q.value}{the computed q-values}
    \item{lfdr}{the local false discovery rate}

\code{glance} returns a data.frame with the model fits
}
\description{
Tidying methods for edge's deSet object
}
\details{
\code{addPheno=TRUE} adds columns that are redundant (since they
add per-sample information to a per-sample-per-gene data frame), but that
are useful for some kinds of graphs and analyses.
}
