% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionSet_tidiers.R
\name{ExpressionSet_tidiers}
\alias{ExpressionSet_tidiers}
\alias{tidy.ExpressionSet}
\title{Tidying methods for Biobase's ExpressionSet objects}
\usage{
\method{tidy}{ExpressionSet}(x, addPheno = FALSE,
  assay = Biobase::assayDataElementNames(x)[1L], ...)
}
\arguments{
\item{x}{ExpressionSet object}

\item{addPheno}{whether columns should be included in the tidied output
for those in the ExpressionSet's phenoData}

\item{assay}{The name of the \code{\link[Biobase]{assayDataElement}} to use
as the values to tidy. Defaults to \code{assayDataElementNames(x)[1L]},
which is usually equivalent to \code{exprs(x)}.}

\item{...}{extra arguments (not used)}
}
\value{
\code{tidy} returns a data frame with one row per gene-sample
combination, with columns
  \item{gene}{gene name}
  \item{sample}{sample name (from column names)}
  \item{value}{expressions on log2 scale}
}
\description{
Tidying methods for Biobase's ExpressionSet objects
}
\details{
\code{addPheno=TRUE} adds columns that are redundant (since they
add per-sample information to a per-sample-per-gene data frame), but that
are useful for some kinds of graphs and analyses.
}
\examples{
library(Biobase)
# import ExpressionSet object
data(hammer)

# Use tidy to extract genes, sample ids and measured value
tidy(hammer)
# add phenoType data
tidy(hammer, addPheno=TRUE)

}
