% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFBM.R
\docType{class}
\name{SFBM-class}
\alias{SFBM-class}
\alias{SFBM_RC}
\alias{as_SFBM}
\title{Class SFBM}
\usage{
as_SFBM(spmat, backingfile = tempfile(), compact = FALSE)
}
\arguments{
\item{spmat}{A 'dgCMatrix' (non-symmetric sparse matrix of type 'double')
or 'dsCMatrix' (symmetric sparse matrix of type 'double').}

\item{backingfile}{Path to file where to store data. Extension \code{.sbk} is
automatically added.}

\item{compact}{Whether to use a compact format? Default is \code{FALSE}.
This is useful when non-zero values in columns are contiguous (or almost).}
}
\value{
The new \link[=SFBM-class]{SFBM}.
}
\description{
A reference class for storing and accessing sparse matrix-like data stored
in files on disk.

Convert a 'dgCMatrix' or 'dsCMatrix' to an SFBM.
}
\details{
An object of class SFBM has many fields:
\itemize{
\item \verb{$address}: address of the external pointer containing the underlying
C++ object to be used as a \verb{XPtr<SFBM>} in C++ code
\item \verb{$extptr}: (internal) use \verb{$address} instead
\item \verb{$nrow}: number of rows
\item \verb{$ncol}: number of columns
\item \verb{$nval}: number of non-zero values
\item \verb{$p}: vector of column positions
\item \verb{$backingfile} or \verb{$sbk}: File with extension 'sbk' that stores the
data of the SFBM
\item \verb{$rds}: 'rds' file (that may not exist) corresponding to the 'sbk' file
\item \verb{$is_saved}: whether this object is stored in \verb{$rds}?
}

And some methods:
\itemize{
\item \verb{$save()}: Save the SFBM object in \verb{$rds}. Returns the SFBM.
\item \verb{$add_columns()}: Add new columns from a 'dgCMatrix' or a 'dsCMatrix'.
\item \verb{$dense_acc()}: Equivalent to \code{as.matrix(.[ind_row, ind_col])}. Use with
caution; \code{ind_row} and \code{ind_col} must be positive indices within range.
}
}

\examples{
spmat2 <- Matrix::Diagonal(4, 0:3)
spmat2[4, 2] <- 5
spmat2[1, 4] <- 6
spmat2[3, 4] <- 7
spmat2

# Stores all (i, x) for x != 0
(X2 <- as_SFBM(spmat2))
matrix(readBin(X2$sbk, what = double(), n = 100), 2)

# Stores only x, but all (even the zero ones) from first to last being not 0
(X3 <- as_SFBM(spmat2, compact = TRUE))
X3$first_i
readBin(X3$sbk, what = double(), n = 100)
}
