% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_bigergm.R
\name{simulate.bigergm}
\alias{simulate.bigergm}
\title{Simulate networks under Exponential Random Graph Models (ERGMs) under local dependence}
\usage{
\method{simulate}{bigergm}(
  object,
  nsim = 1,
  seed = NULL,
  ...,
  output = "network",
  control_within = ergm::control.simulate.formula(),
  verbose = 0
)
}
\arguments{
\item{object}{an object of class \code{bigergm}}

\item{nsim}{number of networks to be randomly drawn from the given distribution on the set of all networks.}

\item{seed}{seed value (integer) for network simulation.}

\item{...}{Additional arguments, passed to \code{\link[ergm]{simulate_formula}}.}

\item{output}{Normally character, one of "network" (default), "stats", "edgelist", to determine the output of the function.}

\item{control_within}{\code{\link[ergm]{control.simulate.formula}} object for fine-tuning ERGM simulation of within-block networks.}

\item{verbose}{If this is TRUE/1, the program will print out additional information about the progress of simulation.}
}
\value{
Simulated networks, the output form depends on the parameter \code{output}
(default is a list of networks).
}
\description{
This function simulates networks under the Exponential Random Graph Model (ERGM)
with local dependence with all parameters set according to the estimated model (\code{object}).
See \code{\link{simulate_bigergm}} for details of the simulation process
}
