% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{bqr_list_datasets}
\alias{bqr_list_datasets}
\title{List BigQuery datasets}
\usage{
bqr_list_datasets(projectId = bqr_get_global_project())
}
\arguments{
\item{projectId}{The BigQuery project ID}
}
\description{
Each projectId can have multiple datasets.
}
\examples{

\dontrun{
  library(bigQueryR)
  
  ## this will open your browser
  ## Authenticate with an email that has access to the BigQuery project you need
  bqr_auth()
  
  ## verify under a new user
  bqr_auth(new_user=TRUE)
  
  ## get projects
  projects <- bqr_list_projects()
  
  my_project <- projects[1]
  
  ## for first project, get datasets
  datasets <- bqr_list_datasets[my_project]
  
}

}
\seealso{
Other bigQuery meta functions: 
\code{\link{bqr_list_projects}()}
}
\concept{bigQuery meta functions}
