% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{dcBinom}
\alias{dcBinom}
\title{Probability Mass function for Lord's Two-Term Approximation to the Compound Binomial Distribution.}
\usage{
dcBinom(x, N, k, p)
}
\arguments{
\item{x}{Value of \code{x} (a specific number of successes).}

\item{N}{The total number of trials.}

\item{k}{Lord's k (see documentation for the \code{Lords.k()} function).}

\item{p}{Probability of success for each trial.}
}
\description{
Gives the density at \code{x} under Lord's two-term approximation to the compound Binomial PMF.
}
\examples{
# Assume some variable follows a compound Binomial distribution with 100
# trials, a 50\% probability of success on each trial, and Lord's k = 1. To
# compute the probability density at a specific point of the distribution
# (e.g., 50):
dcBinom(x = 50, N = 100, k = 1, p = .5)
}
